/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.component;

import chemaxon.marvin.uif.component.MenuFactory;
import chemaxon.marvin.uif.util.swing.SeparatorHandlerLayout;
import java.awt.LayoutManager;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public final class DefaultMenuFactory
implements MenuFactory {
    private static MenuFactory INSTANCE = new DefaultMenuFactory();
    private boolean useLightWeight;

    public static MenuFactory getInstance() {
        return INSTANCE;
    }

    public DefaultMenuFactory() {
        this(true);
    }

    public DefaultMenuFactory(boolean useLightWeightMenu) {
        this.useLightWeight = useLightWeightMenu;
    }

    @Override
    public JCheckBoxMenuItem createCheckBoxMenuItem() {
        return new JCheckBoxMenuItem();
    }

    @Override
    public JMenu createMenu() {
        boolean lightWeight = this.useLightWeight;
        MenuExt result = new MenuExt(lightWeight);
        return result;
    }

    @Override
    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        return menuBar;
    }

    @Override
    public JMenuItem createMenuItem() {
        return new JMenuItem();
    }

    @Override
    public JPopupMenu createPopupMenu() {
        PopupExt result = new PopupExt();
        result.setLightWeightPopupEnabled(this.useLightWeight);
        return result;
    }

    @Override
    public JRadioButtonMenuItem createRadioButtonMenuItem() {
        return new JRadioButtonMenuItem();
    }

    public boolean isUseLightWeight() {
        return this.useLightWeight;
    }

    public void setUseLightWeight(boolean useLightWeight) {
        this.useLightWeight = useLightWeight;
    }

    private static final class MenuExt
    extends JMenu {
        private static final long serialVersionUID = 1L;
        private final boolean lightWeight;

        public MenuExt(boolean lightWeight) {
            this.lightWeight = lightWeight;
        }

        @Override
        protected JMenu.WinListener createWinListener(JPopupMenu p) {
            p.setLightWeightPopupEnabled(this.lightWeight);
            SeparatorHandlerLayout.install(p);
            return super.createWinListener(p);
        }
    }

    private static final class PopupExt
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        @Override
        public void setLayout(LayoutManager mgr) {
            super.setLayout(SeparatorHandlerLayout.createWrapper(this, mgr));
        }
    }
}

