/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.component.ButtonFactory;
import chemaxon.marvin.uif.component.DefaultButtonFactory;
import chemaxon.marvin.uif.component.DefaultMenuFactory;
import chemaxon.marvin.uif.component.MenuFactory;
import chemaxon.marvin.uif.controller.Factory;
import chemaxon.marvin.uif.controller.StyledController;
import chemaxon.marvin.uif.controller.TopLevelController;
import chemaxon.marvin.uif.controller.impl.AbstractTopLevelController;
import chemaxon.marvin.uif.controller.impl.DefaultControllerFactory;
import chemaxon.marvin.uif.controller.impl.MenuBarControllerImpl;
import chemaxon.marvin.uif.controller.impl.PopupControllerImpl;
import chemaxon.marvin.uif.controller.impl.ToolBarControllerImpl;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ToolBarGroup;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public final class ControllerBuilder
implements Factory {
    private ActionRegistry registry;
    private ButtonFactory buttonFactory;
    private MenuFactory menuFactory;

    public ControllerBuilder() {
        this.buttonFactory = DefaultButtonFactory.getInstance();
        this.menuFactory = DefaultMenuFactory.getInstance();
    }

    public ControllerBuilder(ActionRegistry registry, ButtonFactory buttonFactory, MenuFactory menuFactory) {
        this.registry = registry;
        this.buttonFactory = buttonFactory;
        this.menuFactory = menuFactory;
    }

    @Override
    public void setRegistry(ActionRegistry registry) {
        this.registry = registry;
    }

    public ButtonFactory getButtonFactory() {
        return this.buttonFactory;
    }

    @Override
    public void setButtonFactory(ButtonFactory buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    public MenuFactory getMenuFactory() {
        return this.menuFactory;
    }

    @Override
    public void setMenuFactory(MenuFactory menuFactory) {
        this.menuFactory = menuFactory;
    }

    @Override
    public TopLevelController<JMenuBar> createMenuBar(ItemGroup group) {
        return this.createMenuBar(group, "menu");
    }

    public TopLevelController<JMenuBar> createMenuBar(ItemGroup group, String faceName) {
        DefaultControllerFactory factory = this.createFactory(faceName);
        MenuBarControllerImpl controller = new MenuBarControllerImpl(group, factory.getBindingManager(), factory);
        this.configure(controller);
        return controller;
    }

    @Override
    public TopLevelController<JPopupMenu> createPopup(ItemGroup group) {
        return this.createPopup(group, true);
    }

    public TopLevelController<JPopupMenu> createPopup(ItemGroup group, boolean disposeOnClose) {
        return this.createPopup(group, "popup", disposeOnClose);
    }

    public TopLevelController<JPopupMenu> createPopup(ItemGroup group, String faceName) {
        return this.createPopup(group, faceName, true);
    }

    public TopLevelController<JPopupMenu> createPopup(ItemGroup group, String faceName, boolean disposeOnClose) {
        DefaultControllerFactory factory = this.createFactory(faceName);
        factory.setUseLazyMenus(false);
        PopupControllerImpl controller = new PopupControllerImpl(group, factory.getBindingManager(), factory, disposeOnClose);
        this.configure(controller);
        return controller;
    }

    @Override
    public StyledController<JToolBar> createToolBar(ToolBarGroup group) {
        return this.createToolBar(group, "toolbar");
    }

    public StyledController<JToolBar> createToolBar(ToolBarGroup group, String faceName) {
        DefaultControllerFactory factory = this.createFactory(faceName);
        ToolBarControllerImpl controller = new ToolBarControllerImpl(group, factory.getBindingManager(), factory);
        this.configure(controller);
        return controller;
    }

    private DefaultControllerFactory createFactory(String faceName) {
        DefaultControllerFactory result = new DefaultControllerFactory(this.registry, faceName, this.buttonFactory, this.menuFactory);
        result.setUseLazyMenus(true);
        return result;
    }

    private void configure(AbstractTopLevelController<?, ?> controller) {
        controller.setButtonFactory(this.buttonFactory);
        controller.setMenuFactory(this.menuFactory);
    }
}

