/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl;

import chemaxon.marvin.uif.component.MenuFactory;
import chemaxon.marvin.uif.controller.impl.binding.BindingProvider;
import chemaxon.marvin.uif.controller.support.AbstractGroupController;
import chemaxon.marvin.uif.controller.support.ItemControllerFactory;
import chemaxon.marvin.uif.controller.support.MenuItemController;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class MenuController
extends AbstractGroupController<MenuItemController, JMenu>
implements MenuItemController {
    private MenuFactory menuFactory;
    private final BindingProvider provider;
    private MenuHandler menuHandler;
    private boolean dirty;
    private boolean lazyUpdate = true;

    public MenuController(ItemGroup group, ItemControllerFactory factory, BindingProvider provider, MenuFactory menuFactory) {
        super(group, factory);
        this.provider = provider;
        this.menuFactory = menuFactory;
        this.menuHandler = new MenuHandler();
    }

    @Override
    protected JMenu createContainer() {
        return this.menuFactory.createMenu();
    }

    @Override
    protected void initContainer(JMenu container) {
        super.initContainer(container);
        this.provider.bind(container);
        container.addMenuListener(this.menuHandler);
    }

    @Override
    protected void contentChanged() {
        ((JMenu)this.getContainer()).removeAll();
        this.dirty = true;
        if (this.isLazyUpdate()) {
            return;
        }
        this.update();
    }

    private void update() {
        this.contentChangedImpl();
        if (!this.isLazyUpdate()) {
            ((JMenu)this.getContainer()).setVisible(this.hasVisibleMenuComponent() || this.hasVisibleDynamicItem());
        }
        this.dirty = false;
    }

    @Override
    protected void fillContainer(MenuItemController controller) {
        controller.fill((JMenu)this.getContainer());
    }

    private boolean hasVisibleMenuComponent() {
        return MenuController.hasVisibleComponent((JMenu)this.getContainer());
    }

    private static boolean hasVisibleComponent(JMenu menu) {
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            if (!MenuController.isValidVisibleComponent(menu.getMenuComponent(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidVisibleComponent(Component component) {
        return component.isVisible() && !(component instanceof JSeparator);
    }

    @Override
    public void fill(JMenu parent) {
        parent.add((JMenuItem)this.getContainer());
    }

    @Override
    public void fill(JMenuBar menuBar) {
        menuBar.add((JMenu)this.getContainer());
    }

    @Override
    public void fill(JPopupMenu popup) {
        popup.add((JMenuItem)this.getContainer());
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    private boolean needUpdate() {
        return this.hasVisibleDynamicItem() || this.dirty;
    }

    @Override
    public void dispose() {
        if (this.hasComponent()) {
            ((JMenu)this.getContainer()).removeMenuListener(this.menuHandler);
            this.provider.release((JComponent)this.getContainer());
        }
        super.dispose();
    }

    @Override
    protected MenuItemController createController(Item command) {
        return this.createMenuController(command);
    }

    void setMenuFactory(MenuFactory menuFactory) {
        this.menuFactory = menuFactory;
    }

    MenuFactory getMenuFactory() {
        return this.menuFactory;
    }

    void setLazyUpdate(boolean lazyUpdate) {
        this.lazyUpdate = lazyUpdate;
    }

    boolean isLazyUpdate() {
        return this.lazyUpdate;
    }

    private class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            if (MenuController.this.needUpdate()) {
                MenuController.this.update();
            }
        }
    }
}

