/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl;

import chemaxon.marvin.uif.controller.impl.AbstractTopLevelController;
import chemaxon.marvin.uif.controller.impl.binding.BindingManager;
import chemaxon.marvin.uif.controller.support.ItemControllerFactory;
import chemaxon.marvin.uif.controller.support.MenuItemController;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class PopupControllerImpl
extends AbstractTopLevelController<MenuItemController, JPopupMenu> {
    private PopupMenuListener listener = new PopupHandler();
    private boolean disposeOnClose;

    public PopupControllerImpl(ItemGroup group, BindingManager manager, ItemControllerFactory factory, boolean disposeOnClose) {
        super(group, factory, manager);
        this.disposeOnClose = disposeOnClose;
        this.updateBindings();
    }

    @Override
    public JPopupMenu getComponent() {
        return (JPopupMenu)this.getContainer();
    }

    @Override
    protected JPopupMenu createContainer() {
        JPopupMenu result = this.getMenuFactory().createPopupMenu();
        result.addPopupMenuListener(this.listener);
        return result;
    }

    @Override
    protected void fillContainer(MenuItemController controller) {
        controller.fill(this.getComponent());
    }

    @Override
    protected MenuItemController createController(Item command) {
        return this.createMenuController(command);
    }

    private boolean needUpdate() {
        return this.hasVisibleDynamicItem();
    }

    @Override
    public void dispose() {
        if (this.hasComponent()) {
            this.getComponent().removePopupMenuListener(this.listener);
        }
        super.dispose();
    }

    private class PopupHandler
    implements PopupMenuListener {
        private PopupHandler() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (PopupControllerImpl.this.disposeOnClose) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PopupControllerImpl.this.dispose();
                    }
                });
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            if (PopupControllerImpl.this.needUpdate()) {
                PopupControllerImpl.this.contentChanged();
            }
        }
    }
}

