/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl;

import chemaxon.marvin.uif.controller.StyledController;
import chemaxon.marvin.uif.controller.impl.AbstractTopLevelController;
import chemaxon.marvin.uif.controller.impl.binding.Binding;
import chemaxon.marvin.uif.controller.impl.binding.BindingManager;
import chemaxon.marvin.uif.controller.impl.binding.Bindings;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.controller.support.ItemControllerFactory;
import chemaxon.marvin.uif.controller.support.ToolBarItemController;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToolBar;

class ToolBarControllerImpl
extends AbstractTopLevelController<ToolBarItemController, JToolBar>
implements StyledController<JToolBar> {
    private static final Object FLOATABLE_MEMENTO = new Object();
    private Binding binding;
    private boolean useLargeIcons = true;
    private boolean enabled = true;
    private boolean dirty;
    private PropertyChangeListener listener;

    public ToolBarControllerImpl(ToolBarGroup group, BindingManager manager, ItemControllerFactory factory) {
        super(group, factory, manager);
        this.listener = new StyleChangeHandler(this, group);
        group.addPropertyChangeListener(this.listener);
        this.updateBindings();
    }

    @Override
    protected ToolBarItemController createController(Item command) {
        return this.getFactory().createToolBarController(command);
    }

    @Override
    protected void fillContainer(ToolBarItemController controller) {
        controller.fill(this.getComponent());
    }

    @Override
    protected JToolBar createContainer() {
        JToolBar result = this.getButtonFactory().createToolBar();
        this.binding = Bindings.bindNameAndVisibility(result, ((ToolBarGroup)this.getGroup()).getDisplayProperties(), this.getContext());
        this.updateContainer(result, this.isEnabled());
        return result;
    }

    @Override
    protected ConfigurationContext getContext() {
        return new ConfigurationContext(this.getShowMenuIcons(), this.getShowMnemonic(), this.getButtonMode() != 1, this.getButtonMode() != 0, this.getUseLargeIcons(), this.isEnabled());
    }

    @Override
    public JToolBar getComponent() {
        return (JToolBar)this.getContainer();
    }

    private ToolBarGroup getToolBarGroup() {
        return (ToolBarGroup)this.getGroup();
    }

    @Override
    public int getButtonMode() {
        return this.getToolBarGroup().getButtonStyle();
    }

    @Override
    public void setButtonMode(int mode) {
        this.getToolBarGroup().setButtonStyle(mode);
        this.updateBindings();
    }

    @Override
    public boolean getUseLargeIcons() {
        return this.useLargeIcons;
    }

    @Override
    public void setUseLargeIcons(boolean b) {
        this.useLargeIcons = b;
        this.updateBindings();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.updateBindings();
        if (this.hasComponent()) {
            this.updateContainer((JToolBar)this.getContainer(), b);
        }
    }

    @Override
    protected void contentChanged() {
        if (!this.hasComponent()) {
            return;
        }
        if (!this.getGroup().isVisible()) {
            this.dirty = true;
            return;
        }
        this.dirty = false;
        super.contentChanged();
    }

    protected void visibilityChanged() {
        if (!this.dirty) {
            return;
        }
        this.contentChanged();
    }

    private void updateContainer(JToolBar toolBar, boolean b) {
        toolBar.setEnabled(b);
        if (b) {
            if (toolBar.getClientProperty(FLOATABLE_MEMENTO) != null) {
                Boolean floatable = (Boolean)toolBar.getClientProperty(FLOATABLE_MEMENTO);
                toolBar.putClientProperty(FLOATABLE_MEMENTO, null);
                toolBar.setFloatable(floatable);
            }
        } else {
            if (toolBar.getClientProperty(FLOATABLE_MEMENTO) == null) {
                toolBar.putClientProperty(FLOATABLE_MEMENTO, toolBar.isFloatable());
            }
            toolBar.setFloatable(false);
        }
    }

    @Override
    public void dispose() {
        if (this.binding != null) {
            this.binding.release();
        }
        if (this.getToolBarGroup() != null) {
            this.getToolBarGroup().removePropertyChangeListener(this.listener);
        }
        super.dispose();
    }

    private static class StyleChangeHandler
    extends WeakPropertyChangeListener {
        public StyleChangeHandler(ToolBarControllerImpl target, ToolBarGroup source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || evt.getPropertyName().equals("style")) {
                ((ToolBarControllerImpl)target).updateBindings();
            }
            if (evt.getPropertyName() == null || evt.getPropertyName().equals("visible")) {
                ((ToolBarControllerImpl)target).visibilityChanged();
            }
        }
    }
}

