/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.binding;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.support.ActionAdapter;
import chemaxon.marvin.uif.controller.impl.binding.BindingManager;
import chemaxon.marvin.uif.controller.impl.binding.Bindings;
import chemaxon.marvin.uif.model.DisplayProperties;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

public class BindingProvider {
    private final BindingManager manager;
    private final Action action;
    private final DisplayProperties properties;
    private final ActionProperties face;

    BindingProvider(BindingManager manager, DisplayProperties properties) {
        this(manager, null, properties);
    }

    BindingProvider(BindingManager manager, Action action, DisplayProperties properties) {
        this(manager, action, new ActionAdapter(action), properties);
    }

    BindingProvider(BindingManager manager, Action action, ActionProperties face, DisplayProperties properties) {
        this.manager = manager;
        this.action = action;
        this.properties = properties;
        this.face = face;
    }

    public void bind(JMenu menu) {
        this.manager.registerBinding(menu, Bindings.bind(menu, this.action, this.face, this.properties, this.manager.getContext()));
    }

    public void bind(JMenuItem item) {
        this.manager.registerBinding(item, Bindings.bind(item, this.action, this.face, this.properties, this.manager.getContext()));
    }

    public void bind(JRadioButtonMenuItem item) {
        this.manager.registerBinding(item, Bindings.bind(item, this.action, this.face, this.properties, this.manager.getContext()));
    }

    public void bind(JCheckBoxMenuItem item) {
        this.manager.registerBinding(item, Bindings.bind(item, this.action, this.face, this.properties, this.manager.getContext()));
    }

    public void bind(JToggleButton button) {
        this.manager.registerBinding(button, Bindings.bind(button, this.action, this.face, this.properties, this.manager.getContext()));
    }

    public void bind(AbstractButton button) {
        this.manager.registerBinding(button, Bindings.bind(button, this.action, this.face, this.properties, this.manager.getContext()));
    }

    public void bind(JComponent component) {
        this.manager.registerBinding(component, Bindings.bind(component, this.properties, this.manager.getContext()));
    }

    public void release(JComponent component) {
        this.manager.release(component);
    }
}

