/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.binding;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.controller.impl.binding.Binding;
import chemaxon.marvin.uif.controller.impl.binding.ButtonBinding;
import chemaxon.marvin.uif.controller.impl.binding.ComponentBinding;
import chemaxon.marvin.uif.controller.impl.binding.ComponentNameBinding;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.controller.impl.binding.MenuConfigurer;
import chemaxon.marvin.uif.controller.impl.binding.MenuItemConfigurer;
import chemaxon.marvin.uif.controller.impl.binding.ToggleButtonBinding;
import chemaxon.marvin.uif.controller.impl.binding.ToolBarButtonConfigurer;
import chemaxon.marvin.uif.model.DisplayProperties;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

public final class Bindings {
    private Bindings() {
    }

    public static Binding bind(JMenuItem menuItem, Action action, ActionProperties face, DisplayProperties properties) {
        return Bindings.bind(menuItem, action, face, properties, new ConfigurationContext());
    }

    public static Binding bind(JMenuItem menuItem, Action action, ActionProperties face, DisplayProperties properties, ConfigurationContext initialContext) {
        return new ButtonBinding(menuItem, action, face, properties, MenuItemConfigurer.getInstance(), initialContext);
    }

    public static Binding bind(JMenu menuItem, Action action, ActionProperties face, DisplayProperties properties) {
        return Bindings.bind(menuItem, action, face, properties, new ConfigurationContext());
    }

    public static Binding bind(JMenu menu, Action action, ActionProperties face, DisplayProperties properties, ConfigurationContext initialContext) {
        return new ButtonBinding(menu, action, face, properties, MenuConfigurer.getInstance(), initialContext);
    }

    public static Binding bind(JRadioButtonMenuItem menuItem, Action action) {
        return Bindings.bind(menuItem, action, null, null);
    }

    public static Binding bind(JComponent component, DisplayProperties properties, ConfigurationContext context) {
        return new ComponentBinding(component, properties, context);
    }

    public static Binding bind(JRadioButtonMenuItem menuItem, Action action, ActionProperties face, DisplayProperties properties) {
        return Bindings.bind(menuItem, action, face, properties, new ConfigurationContext());
    }

    public static Binding bind(JRadioButtonMenuItem menuItem, Action action, ActionProperties face, DisplayProperties properties, ConfigurationContext context) {
        return new ToggleButtonBinding(menuItem, action, face, properties, MenuItemConfigurer.getInstance(), context);
    }

    public static Binding bind(JCheckBoxMenuItem menuItem, Action action) {
        return Bindings.bind(menuItem, action, null, null);
    }

    public static Binding bind(JCheckBoxMenuItem menuItem, Action action, ActionProperties face, DisplayProperties properties) {
        return Bindings.bind(menuItem, action, face, properties, new ConfigurationContext());
    }

    public static Binding bind(JCheckBoxMenuItem menuItem, Action action, ActionProperties face, DisplayProperties properties, ConfigurationContext context) {
        return new ToggleButtonBinding(menuItem, action, face, properties, MenuItemConfigurer.getInstance(), context);
    }

    public static Binding bind(JToggleButton button, Action action, ActionProperties face, DisplayProperties properties) {
        return Bindings.bind(button, action, face, properties, new ConfigurationContext());
    }

    public static Binding bind(JToggleButton button, Action action, ActionProperties face, DisplayProperties properties, ConfigurationContext context) {
        return new ToggleButtonBinding(button, action, face, properties, ToolBarButtonConfigurer.getInstance(), context);
    }

    public static Binding bind(AbstractButton button, Action action, ActionProperties face, DisplayProperties properties) {
        return Bindings.bind(button, action, face, properties, new ConfigurationContext());
    }

    public static Binding bind(AbstractButton button, Action action, ActionProperties face, DisplayProperties properties, ConfigurationContext context) {
        return new ButtonBinding(button, action, face, properties, ToolBarButtonConfigurer.getInstance(), context);
    }

    public static Binding bindComponent(JComponent component, DisplayProperties properties, ConfigurationContext context) {
        return new ComponentBinding(component, properties, context);
    }

    public static Binding bindNameAndVisibility(JComponent component, DisplayProperties properties, ConfigurationContext context) {
        return new ComponentNameBinding(component, properties, context);
    }
}

