/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.binding;

import chemaxon.marvin.uif.controller.impl.binding.Binding;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.model.DisplayProperties;
import javax.swing.JComponent;

class ComponentBinding
implements Binding {
    private static final String PREVIOUS_ENABLED_VALUE = "previousEnabledValue";
    private JComponent component;
    private DisplayProperties properties;

    ComponentBinding(JComponent component, DisplayProperties properties, ConfigurationContext initialContext) {
        this.component = component;
        this.properties = properties;
        component.putClientProperty("helpID", properties.getHelpID());
        this.setContext(initialContext);
    }

    @Override
    public void release() {
        this.component = null;
        this.properties = null;
    }

    protected final JComponent getComponent() {
        return this.component;
    }

    protected final DisplayProperties getPropeties() {
        return this.properties;
    }

    @Override
    public void setContext(ConfigurationContext context) {
        if (this.component != null && context.isEnabled() != this.component.isEnabled()) {
            if (context.isEnabled()) {
                Boolean b = (Boolean)this.component.getClientProperty(PREVIOUS_ENABLED_VALUE);
                if (b != null) {
                    this.component.setEnabled(b);
                    this.component.putClientProperty(PREVIOUS_ENABLED_VALUE, null);
                }
            } else {
                this.component.putClientProperty(PREVIOUS_ENABLED_VALUE, this.component.isEnabled());
                this.component.setEnabled(false);
            }
        }
    }
}

