/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.binding;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.controller.impl.binding.Configurer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

class MenuConfigurer
implements Configurer {
    private static Configurer INSTANCE = new MenuConfigurer();

    MenuConfigurer() {
    }

    public static Configurer getInstance() {
        return INSTANCE;
    }

    @Override
    public void configure(JComponent component, ActionProperties properties, ConfigurationContext context) {
        AbstractButton button = (AbstractButton)component;
        button.setText(properties.getName());
        if (context.isMenuMnemonicEnabled()) {
            if (properties.getMnemonicKey() != null) {
                button.setMnemonic(properties.getMnemonicKey());
            } else {
                button.setMnemonic('\u0000');
            }
            if (properties.getDisplayedMnemonicIndex() != null) {
                button.setDisplayedMnemonicIndex(properties.getDisplayedMnemonicIndex());
            }
        } else {
            button.setMnemonic('\u0000');
        }
        if (context.isMenuIconsEnabled()) {
            button.setIcon(properties.getSmallIcon());
        } else {
            button.setIcon(null);
        }
        if (properties.getHelpID() != null) {
            button.putClientProperty("helpID", properties.getHelpID());
        }
    }
}

