/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.binding;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.controller.impl.binding.Configurer;
import chemaxon.marvin.uif.util.swing.DropDownToggleButton;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;

class ToolBarButtonConfigurer
implements Configurer {
    private static Configurer INSTANCE = new ToolBarButtonConfigurer();

    private ToolBarButtonConfigurer() {
    }

    public static Configurer getInstance() {
        return INSTANCE;
    }

    @Override
    public void configure(JComponent component, ActionProperties properties, ConfigurationContext context) {
        AbstractButton button = (AbstractButton)component;
        if (context.isToolbarTextEnabled()) {
            button.setText(properties.getName());
        } else {
            button.setText(null);
        }
        if (context.isToolbarIconsEnabled() || button instanceof DropDownToggleButton) {
            Icon icon = context.getUseLargeToolBarIcons() && properties.getLargeIcon() != null ? properties.getLargeIcon() : properties.getSmallIcon();
            button.setIcon(icon);
            if (icon == null) {
                button.setText(properties.getName());
            }
        } else {
            button.setIcon(null);
        }
        button.setMnemonic('\u0000');
        if (properties.getShortDescription() != null) {
            button.setToolTipText(properties.getShortDescription());
        } else {
            button.setToolTipText(properties.getName());
        }
        if (properties.getHelpID() != null) {
            button.putClientProperty("helpID", properties.getHelpID());
        }
    }
}

