/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.item;

import chemaxon.marvin.uif.component.ButtonFactory;
import chemaxon.marvin.uif.component.MenuFactory;
import chemaxon.marvin.uif.controller.impl.binding.BindingProvider;
import chemaxon.marvin.uif.controller.support.ItemController;
import javax.swing.JComponent;

abstract class AbstractItemController
implements ItemController {
    private ButtonFactory buttonFactory;
    private MenuFactory menuFactory;
    private BindingProvider bindingProvider;
    private JComponent component;

    public AbstractItemController(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    protected boolean hasComponent() {
        return this.component != null;
    }

    protected abstract JComponent createAndBindItem();

    protected final JComponent getComponent() {
        if (!this.hasComponent()) {
            this.component = this.createAndBindItem();
        }
        return this.component;
    }

    protected final BindingProvider getProvider() {
        return this.bindingProvider;
    }

    protected final void setProvider(BindingProvider provider) {
        this.bindingProvider = provider;
    }

    @Override
    public void dispose() {
        if (this.hasComponent()) {
            this.getProvider().release(this.component);
            this.component = null;
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    ButtonFactory getButtonFactory() {
        return this.buttonFactory;
    }

    void setButtonFactory(ButtonFactory buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    MenuFactory getMenuFactory() {
        return this.menuFactory;
    }

    @Override
    public void updateUI() {
        if (this.hasComponent() && this.component.getParent() == null) {
            this.component.updateUI();
        }
    }

    void setMenuFactory(MenuFactory menuFactory) {
        this.menuFactory = menuFactory;
    }
}

