/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.item;

import chemaxon.marvin.uif.action.DynamicMenuProvider;
import chemaxon.marvin.uif.controller.impl.item.ItemFactory;
import chemaxon.marvin.uif.controller.support.MenuItemController;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;

class DynamicMenuItem
implements MenuItemController {
    private ItemFactory factory;
    private DynamicMenuProvider provider;
    private Map<Action, MenuItemController> cachedControllers;

    public DynamicMenuItem(DynamicMenuProvider provider, ItemFactory factory) {
        this.provider = provider;
        this.factory = factory;
        this.cachedControllers = new WeakHashMap<Action, MenuItemController>();
    }

    @Override
    public void fill(JMenu menu) {
        MenuItemController[] controllers = this.getControllers();
        for (int i = 0; i < controllers.length; ++i) {
            controllers[i].fill(menu);
        }
    }

    private MenuItemController[] getControllers() {
        Action[] components = this.provider.getMenuItems();
        MenuItemController[] result = new MenuItemController[components.length];
        for (int i = 0; i < result.length; ++i) {
            MenuItemController controller = this.cachedControllers.remove(components[i]);
            if (controller == null) {
                controller = this.factory.createDynamicChildController(this.provider, components[i]);
            }
            result[i] = controller;
        }
        this.setCachedControllers(components, result);
        return result;
    }

    private void setCachedControllers(Action[] components, MenuItemController[] result) {
        this.disposeCachedControllers();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            this.cachedControllers.put(components[i], result[i]);
        }
    }

    private void disposeCachedControllers() {
        for (MenuItemController controller : this.cachedControllers.values()) {
            if (controller == null) continue;
            controller.dispose();
        }
        this.cachedControllers.clear();
    }

    @Override
    public void fill(JMenuBar menuBar) {
    }

    @Override
    public void fill(JPopupMenu popup) {
        for (MenuItemController controller : this.getControllers()) {
            controller.fill(popup);
        }
    }

    @Override
    public void updateUI() {
        for (MenuItemController controller : this.cachedControllers.values()) {
            controller.updateUI();
        }
    }

    @Override
    public void dispose() {
        this.disposeCachedControllers();
    }

    @Override
    public boolean isDynamic() {
        return ((Action)((Object)this.provider)).isEnabled();
    }
}

