/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.item;

import chemaxon.marvin.uif.action.ActionGroup;
import chemaxon.marvin.uif.action.ComponentProvider;
import chemaxon.marvin.uif.action.DynamicMenuProvider;
import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import chemaxon.marvin.uif.component.ButtonFactory;
import chemaxon.marvin.uif.component.MenuFactory;
import chemaxon.marvin.uif.controller.impl.binding.BindingManager;
import chemaxon.marvin.uif.controller.impl.binding.BindingProvider;
import chemaxon.marvin.uif.controller.impl.item.AbstractItemController;
import chemaxon.marvin.uif.controller.impl.item.AbstractMenuItemController;
import chemaxon.marvin.uif.controller.impl.item.AbstractToolBarItemController;
import chemaxon.marvin.uif.controller.impl.item.ActionGroupToolbarController;
import chemaxon.marvin.uif.controller.impl.item.CheckBoxMenuController;
import chemaxon.marvin.uif.controller.impl.item.CustomMenuItemController;
import chemaxon.marvin.uif.controller.impl.item.CustomToolBarItemController;
import chemaxon.marvin.uif.controller.impl.item.DefaultMenuItemController;
import chemaxon.marvin.uif.controller.impl.item.DefaultToolBarItemController;
import chemaxon.marvin.uif.controller.impl.item.DynamicMenuItem;
import chemaxon.marvin.uif.controller.impl.item.RadioMenuController;
import chemaxon.marvin.uif.controller.impl.item.ToggleItemController;
import chemaxon.marvin.uif.controller.support.MenuItemController;
import chemaxon.marvin.uif.controller.support.SeparatorController;
import chemaxon.marvin.uif.controller.support.ToolBarItemController;
import chemaxon.marvin.uif.model.DisplayProperties;
import javax.swing.Action;

public class ItemFactory {
    private ButtonFactory buttonFactory;
    private MenuFactory menuFactory;
    private final BindingManager manager;

    public ItemFactory(BindingManager manager, MenuFactory menuFactory, ButtonFactory buttonFactory) {
        this.manager = manager;
        this.menuFactory = menuFactory;
        this.buttonFactory = buttonFactory;
    }

    public MenuItemController createController(Action action, DisplayProperties properties) {
        if (action == null) {
            return new SeparatorController();
        }
        return this.createController(action, this.createProvider(action, properties));
    }

    public MenuItemController createController(Action action) {
        return this.createController(action, (DisplayProperties)null);
    }

    public MenuItemController createController(Action action, String faceName) {
        if (action == null) {
            return new SeparatorController();
        }
        return this.createController(action, this.createProvider(action, faceName));
    }

    public MenuItemController createController(Action action, BindingProvider provider) {
        return this.createControllerImpl(action, provider, true);
    }

    public MenuItemController createDynamicChildController(DynamicMenuProvider parent, Action action) {
        if (action == null) {
            return new SeparatorController();
        }
        return this.createControllerImpl(action, this.createProvider(action, (DisplayProperties)null), parent != action);
    }

    private MenuItemController createControllerImpl(Action action, BindingProvider provider, boolean handleDynamic) {
        AbstractMenuItemController result;
        if (action instanceof ComponentProvider.MenuItemProvider) {
            result = new CustomMenuItemController((ComponentProvider.MenuItemProvider)action, provider);
        } else {
            if (action instanceof DynamicMenuProvider && handleDynamic) {
                return new DynamicMenuItem((DynamicMenuProvider)((Object)action), this);
            }
            result = AbstractExtendedAction.isToggleAction(action) ? (AbstractExtendedAction.isRadio(action) ? new RadioMenuController(provider) : new CheckBoxMenuController(provider)) : new DefaultMenuItemController(provider);
        }
        this.configure(result);
        return result;
    }

    public ToolBarItemController createToolBarController(Action action) {
        return this.createToolBarController(action, null);
    }

    public ToolBarItemController createToolBarController(Action action, DisplayProperties properties) {
        AbstractToolBarItemController result;
        BindingProvider provider = this.createProvider(action, properties);
        if (action instanceof ComponentProvider.ToolBarItemProvider) {
            result = new CustomToolBarItemController((ComponentProvider.ToolBarItemProvider)action, provider);
        } else if (action instanceof ActionGroup) {
            ActionGroup group = (ActionGroup)action;
            Action defaultAction = group.getDefaultAction() != null ? group.getDefaultAction() : group;
            result = new ActionGroupToolbarController(this.createProvider(defaultAction), group, this);
        } else {
            result = AbstractExtendedAction.isToggleAction(action) ? new ToggleItemController(provider) : new DefaultToolBarItemController(provider);
        }
        this.configure(result);
        return result;
    }

    public BindingProvider createProvider(Action action, String faceName) {
        return this.manager.createProvider(action, faceName);
    }

    public BindingProvider createProvider(Action action) {
        return this.createProvider(action, (DisplayProperties)null);
    }

    public BindingProvider createProvider(Action action, DisplayProperties properties) {
        return this.manager.createProvider(action, properties);
    }

    private void configure(AbstractItemController result) {
        result.setButtonFactory(this.buttonFactory);
        result.setMenuFactory(this.menuFactory);
    }

    public void setButtonFactory(ButtonFactory buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    public void setMenuFactory(MenuFactory menuFactory) {
        this.menuFactory = menuFactory;
    }
}

