/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.action.support.LabelInfo;
import chemaxon.marvin.uif.dialog.model.CategoryHelper;
import chemaxon.marvin.uif.dialog.model.ItemGroupModel;
import chemaxon.marvin.uif.dialog.model.ListModelAdapter;
import chemaxon.marvin.uif.model.DefaultItem;
import chemaxon.marvin.uif.util.bean.Model;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CategoriesModel
extends Model {
    public static final String PROPERTY_SELECTED_ACTION = "selectedAction";
    private static final String ADD_ACTION = "add.name";
    private ResourceBundle bundle;
    private final ItemGroupModel target;
    private ActionRegistry registry;
    private CategoryHelper helper;
    private ListModel categoriesModel;
    private ListSelectionModel categorySelection;
    private ListModelAdapter currentCategory;
    private ListSelectionModel commandSelection;
    private Action addAction;
    private MouseListener doubleClickHandler;

    public CategoriesModel(ItemGroupModel target, ActionRegistry registry) {
        this.target = target;
        this.registry = registry;
        this.bundle = ResourceBundle.getBundle(this.getClass().getName());
        this.initModels();
        this.initActions();
        this.initEventHandling();
        this.updateSelection();
    }

    private void updateSelection() {
        if (this.categoriesModel.getSize() != 0) {
            this.categorySelection.setSelectionInterval(0, 0);
        }
    }

    private void initModels() {
        this.helper = new CategoryHelper(this.registry);
        this.categoriesModel = new ListModelAdapter(this.helper.getCategories());
        this.categorySelection = new DefaultListSelectionModel();
        this.categorySelection.setSelectionMode(0);
        this.currentCategory = new ListModelAdapter(null);
        this.commandSelection = new DefaultListSelectionModel();
        this.commandSelection.setSelectionMode(0);
    }

    private void initEventHandling() {
        this.categorySelection.addListSelectionListener(new CategorySelectionChangeHandler());
        this.commandSelection.addListSelectionListener(new CommandSelectionChangeHandler());
    }

    private void initActions() {
        this.doubleClickHandler = new DoubleClickHandler();
        this.addAction = new AddAction();
        LabelInfo.parse(this.bundle.getString(ADD_ACTION)).configure(this.addAction);
        this.updateActionEnablement();
    }

    private void updateActionEnablement() {
        this.addAction.setEnabled(this.hasSelectedCommand());
    }

    private boolean hasSelectedCommand() {
        return this.getSelectedCommand() != null;
    }

    private void doAdd() {
        if (!this.hasSelectedCommand()) {
            return;
        }
        this.target.add(new DefaultItem(this.getSelectedCommand()));
        if (this.commandSelection.getMinSelectionIndex() < this.currentCategory.getSize() - 1) {
            this.commandSelection.setSelectionInterval(this.commandSelection.getMinSelectionIndex() + 1, this.commandSelection.getMinSelectionIndex() + 1);
        }
    }

    private Action getAction(String id) {
        return this.registry.getAction(id);
    }

    public ListModel getCategoriesList() {
        return this.categoriesModel;
    }

    public ListSelectionModel getCategorySelection() {
        return this.categorySelection;
    }

    public ListModel getCommandsList() {
        return this.currentCategory;
    }

    public ListSelectionModel getCommandSelection() {
        return this.commandSelection;
    }

    public Action getAddAction() {
        return this.addAction;
    }

    public MouseListener getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public Action getSelectedAction() {
        return this.hasSelectedCommand() ? this.getAction(this.getSelectedCommand()) : null;
    }

    public String getDescription() {
        if (this.hasSelectedCommand()) {
            return (String)this.getAction(this.getSelectedCommand()).getValue("LongDescription");
        }
        return null;
    }

    private String getSelectedCommand() {
        if (this.getSelectedCategory() == null || this.commandSelection.isSelectionEmpty()) {
            return null;
        }
        return this.helper.getActionIDs(this.getSelectedCategory().getID()).get(this.commandSelection.getMinSelectionIndex());
    }

    private Category getSelectedCategory() {
        return this.categorySelection.isSelectionEmpty() ? null : (Category)this.categoriesModel.getElementAt(this.categorySelection.getMinSelectionIndex());
    }

    private void updateCategorySelection() {
        this.currentCategory.setDelegate(this.convert(this.getCurrentCommands()));
        if (this.currentCategory.getSize() != 0) {
            this.commandSelection.setSelectionInterval(0, 0);
        }
    }

    private List convert(List ids) {
        if (ids == null) {
            return null;
        }
        ArrayList<Action> result = new ArrayList<Action>(ids.size());
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            result.add(this.getAction((String)it.next()));
        }
        return result;
    }

    private List getCurrentCommands() {
        return this.getSelectedCategory() != null ? this.helper.getActionIDs(this.getSelectedCategory().getID()) : null;
    }

    private class CommandSelectionChangeHandler
    implements ListSelectionListener {
        private CommandSelectionChangeHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            CategoriesModel.this.updateActionEnablement();
            CategoriesModel.this.firePropertyChange(CategoriesModel.PROPERTY_SELECTED_ACTION, null, CategoriesModel.this.getSelectedAction());
        }
    }

    private class CategorySelectionChangeHandler
    implements ListSelectionListener {
        private CategorySelectionChangeHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            CategoriesModel.this.updateCategorySelection();
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            CategoriesModel.this.doAdd();
        }
    }

    private class DoubleClickHandler
    extends MouseAdapter {
        private DoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                CategoriesModel.this.doAdd();
            }
        }
    }
}

