/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.Category;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;

class CategoryHelper {
    private Map<String, List<String>> categoryMap;
    private List<Category> categories = new ArrayList<Category>();
    private ActionRegistry registry;

    public CategoryHelper(ActionRegistry registry) {
        this.categoryMap = new HashMap<String, List<String>>();
        this.registry = registry;
        this.init();
        Collections.sort(this.categories, new CategoryComparator());
    }

    private void init() {
        for (String id : this.registry.getActionIDs()) {
            String categoryID = this.registry.getActionCategoryID(id);
            if (categoryID == null) continue;
            this.getActionIDs(categoryID).add(id);
        }
        ActionComparator comp = new ActionComparator();
        for (Category category : this.getCategories()) {
            Collections.sort(this.getActionIDs(category), comp);
        }
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public List<String> getActionIDs(Category category) {
        if (category == null) {
            throw new NullPointerException();
        }
        return this.getActionIDs(category.getID());
    }

    public List<String> getActionIDs(String categoryID) {
        if (categoryID == null) {
            throw new NullPointerException();
        }
        List<String> result = this.categoryMap.get(categoryID);
        if (result == null) {
            result = new ArrayList<String>();
            this.categories.add(this.registry.getCategory(categoryID));
            this.categoryMap.put(categoryID, result);
        }
        return result;
    }

    public List<Action> convertIDsToActons(List<String> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        ArrayList<Action> result = new ArrayList<Action>(ids.size());
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            result.add(this.registry.getAction(it.next()));
        }
        return result;
    }

    private static int compareString(String name1, String name2) {
        if (name1 == null && name2 == null) {
            return 0;
        }
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    private class ActionComparator
    implements Comparator<String> {
        private ActionComparator() {
        }

        @Override
        public int compare(String arg1, String arg2) {
            Action a1 = CategoryHelper.this.registry.getAction(arg1);
            Action a2 = CategoryHelper.this.registry.getAction(arg2);
            String name1 = (String)a1.getValue("Name");
            String name2 = (String)a2.getValue("Name");
            return CategoryHelper.compareString(name1, name2);
        }
    }

    private class CategoryComparator
    implements Comparator<Category> {
        private CategoryComparator() {
        }

        @Override
        public int compare(Category arg1, Category arg2) {
            Category cat1 = arg1;
            Category cat2 = arg2;
            String name1 = cat1.getDisplayName();
            String name2 = cat2.getDisplayName();
            return CategoryHelper.compareString(name1, name2);
        }
    }
}

