/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.dialog.model.DialogProvider;
import chemaxon.marvin.uif.dialog.model.MenuManagerModel;
import chemaxon.marvin.uif.dialog.model.PopupManagerModel;
import chemaxon.marvin.uif.dialog.model.SchemeManagerModel;
import chemaxon.marvin.uif.dialog.model.ToolBarManagerModel;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.shortcut.ShortcutManager;

public class CustomizeGUIModel {
    private GUIRegistry guiRegistry;
    private ActionRegistry actionRegistry;
    private ShortcutManager shortcutManager;
    private ToolBarManagerModel toolBarManagerModel;
    private PopupManagerModel popupManagerModel;
    private MenuManagerModel menuManagerModel;
    private SchemeManagerModel schemeManagerModel;
    private boolean editToolBars;
    private boolean editMenuBar;
    private boolean editPopups;
    private boolean editShortcuts;

    public CustomizeGUIModel(GUIRegistry guiRegistry, ActionRegistry actionRegistry, ShortcutManager shortcutManager, DialogProvider categories, DialogProvider menuMove, DialogProvider shortcutEditor) {
        this.guiRegistry = guiRegistry;
        this.actionRegistry = actionRegistry;
        this.shortcutManager = shortcutManager;
        this.editToolBars = true;
        this.editPopups = true;
        this.editMenuBar = true;
        this.editShortcuts = true;
        this.initModels(categories, menuMove, shortcutEditor);
    }

    private void initModels(DialogProvider categories, DialogProvider menuMove, DialogProvider shortcutEditor) {
        this.toolBarManagerModel = new ToolBarManagerModel(this.guiRegistry, this.actionRegistry, categories);
        this.popupManagerModel = new PopupManagerModel(this.guiRegistry, this.actionRegistry, categories);
        this.menuManagerModel = new MenuManagerModel(this.guiRegistry.getMenuBar(), this.actionRegistry, categories, menuMove);
        this.schemeManagerModel = new SchemeManagerModel(this.shortcutManager, this.actionRegistry, shortcutEditor);
    }

    private boolean hasMenuBar() {
        return this.guiRegistry.getMenuBar() != null;
    }

    private boolean hasPopups() {
        return this.guiRegistry.getPopupIDs().length != 0;
    }

    private boolean hasToolBars() {
        return this.guiRegistry.getToolBarIDs().length != 0;
    }

    private boolean hasShortcuts() {
        return this.shortcutManager.getShortcutSchemes().length != 0;
    }

    public boolean getCanAddDeleteToolbar() {
        return this.toolBarManagerModel.getCanAddDelete();
    }

    public void setCanAddDeleteToolbar(boolean canAddDeleteToolbar) {
        this.toolBarManagerModel.setCanAddDelete(canAddDeleteToolbar);
    }

    public boolean canEditMenuBar() {
        return this.editMenuBar && this.hasMenuBar();
    }

    public void setEditMenuBar(boolean editMenuBar) {
        this.editMenuBar = editMenuBar;
    }

    public boolean canEditPopups() {
        return this.editPopups && this.hasPopups();
    }

    public boolean canEditShortcuts() {
        return this.editShortcuts && this.hasShortcuts();
    }

    public void setEditPopups(boolean editPopups) {
        this.editPopups = editPopups;
    }

    public boolean canEditToolBars() {
        return this.editToolBars && (this.hasToolBars() || this.getCanAddDeleteToolbar());
    }

    public void setEditToolBars(boolean editToolBars) {
        this.editToolBars = editToolBars;
    }

    public void setEditShortcuts(boolean editShortcuts) {
        this.editShortcuts = editShortcuts;
    }

    public void release() {
        this.menuManagerModel.release();
        this.toolBarManagerModel.release();
        this.popupManagerModel.release();
    }

    public MenuManagerModel getMenuModel() {
        return this.menuManagerModel;
    }

    public PopupManagerModel getPopupModel() {
        return this.popupManagerModel;
    }

    public ToolBarManagerModel getToolBarModel() {
        return this.toolBarManagerModel;
    }

    public SchemeManagerModel getSchemeModel() {
        return this.schemeManagerModel;
    }
}

