/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.dialog.model.ListModelAdapter;
import chemaxon.marvin.uif.model.GroupEvent;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ItemGroupListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ItemListAdapter
extends ListModelAdapter {
    private ItemGroupListener listener = new GroupChangeHandler();
    private PropertyChangeListener propertyListener = new PropertyChangeHandler();
    private ItemGroup group;

    public ItemListAdapter(ItemGroup group) {
        this.setGroup(group);
    }

    private void addListener(Item item) {
        this.removeListener(item);
        if (item != null && item.getDisplayProperties() != null) {
            item.getDisplayProperties().addPropertyChangeListener(this.propertyListener);
        }
    }

    private void removeListener(Item item) {
        if (item != null && item.getDisplayProperties() != null) {
            item.getDisplayProperties().removePropertyChangeListener(this.propertyListener);
        }
    }

    public void setGroup(ItemGroup newGroup) {
        if (this.group != null) {
            this.group.removeItemGroupListener(this.listener);
        }
        this.group = newGroup;
        this.setDelegate(ItemListAdapter.getValidItems(this.group));
        if (this.group != null) {
            this.group.addItemGroupListener(this.listener);
        }
        this.addListeners(this.getDelegate());
    }

    @Override
    public void setDelegate(List list) {
        if (list == null) {
            return;
        }
        this.removeListeners(super.getDelegate());
        super.setDelegate(list);
        this.addListeners(super.getDelegate());
    }

    private void addListeners(List list) {
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.addListener((Item)it.next());
        }
    }

    private void removeListeners(List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.removeListener((Item)it.next());
        }
    }

    private static List getValidItems(ItemGroup group) {
        if (group == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Item> result = new ArrayList<Item>();
        for (int i = 0; i < group.getItemCount(); ++i) {
            result.add(group.getItem(i));
        }
        return result;
    }

    private void rebuildList() {
        this.setDelegate(ItemListAdapter.getValidItems(this.group));
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ItemListAdapter.this.fireContentsChanged(this, 0, ItemListAdapter.this.getSize());
        }
    }

    private class GroupChangeHandler
    implements ItemGroupListener {
        private GroupChangeHandler() {
        }

        @Override
        public void itemAdded(GroupEvent e) {
            ItemListAdapter.this.addListener(e.getChild());
            ItemListAdapter.this.insertElement(e.getChild(), ItemListAdapter.getValidItems(e.getGroup()).indexOf(e.getChild()));
        }

        @Override
        public void itemMoved(GroupEvent e) {
            ItemListAdapter.this.rebuildList();
        }

        @Override
        public void itemRemoved(GroupEvent e) {
            ItemListAdapter.this.removeListener(e.getChild());
            ItemListAdapter.this.removeElement(e.getChild());
        }
    }
}

