/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.view;

import chemaxon.marvin.uif.dialog.model.CustomizeGUIModel;
import chemaxon.marvin.uif.dialog.view.MenuView;
import chemaxon.marvin.uif.dialog.view.PopupView;
import chemaxon.marvin.uif.dialog.view.SchemeView;
import chemaxon.marvin.uif.dialog.view.ToolBarView;
import chemaxon.marvin.uif.util.swing.AbstractView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CustomizeView
extends AbstractView {
    private CustomizeGUIModel model;

    public CustomizeView(CustomizeGUIModel model) {
        this.model = model;
    }

    @Override
    protected JComponent buildComponent() {
        ViewEntry[] views = this.getViews();
        if (views.length > 1) {
            return this.createTabbedPane(views);
        }
        return this.createSinglePane(views);
    }

    private JComponent createSinglePane(ViewEntry[] views) {
        return views[0].view.getComponent();
    }

    private JComponent createTabbedPane(ViewEntry[] views) {
        JTabbedPane result = new JTabbedPane();
        for (int i = 0; i < views.length; ++i) {
            result.add(views[i].title, this.createViewPanel(views[i].view));
        }
        return result;
    }

    private Component createViewPanel(AbstractView view) {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 0));
        result.add((Component)view.getComponent(), "Center");
        return result;
    }

    private ViewEntry[] getViews() {
        ArrayList<ViewEntry> result = new ArrayList<ViewEntry>();
        if (this.model.canEditMenuBar()) {
            result.add(new ViewEntry(this.getString("menuview.title"), new MenuView(this.model.getMenuModel())));
        }
        if (this.model.canEditPopups()) {
            result.add(new ViewEntry(this.getString("popupview.title"), new PopupView(this.model.getPopupModel())));
        }
        if (this.model.canEditToolBars()) {
            result.add(new ViewEntry(this.getString("toolbarview.title"), new ToolBarView(this.model.getToolBarModel())));
        }
        if (this.model.canEditShortcuts()) {
            result.add(new ViewEntry(this.getString("shortcutview.title"), new SchemeView(this.model.getSchemeModel())));
        }
        return result.toArray(new ViewEntry[result.size()]);
    }

    private static class ViewEntry {
        private String title;
        private AbstractView view;

        private ViewEntry(String title, AbstractView view) {
            this.title = title;
            this.view = view;
        }
    }
}

