/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.view;

import chemaxon.marvin.uif.dialog.model.ShortcutModel;
import chemaxon.marvin.uif.shortcut.ShortcutEditorField;
import chemaxon.marvin.uif.util.swing.AbstractView;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ShortcutEditorView
extends AbstractView
implements PropertyChangeListener,
ActionListener {
    private static final int FIELD_WIDTH = 40;
    private static final String SHORTCUT_LABEL = "shortcut.label";
    private static final String BASED_ON_LABEL = "assigned.label";
    private ShortcutModel model;
    private MessageFormat assignedLabelFomat;
    private JButton tabButton;
    private JButton clearButton;
    private ShortcutEditorField field;
    private JLabel assignedCommandLabel;
    private boolean updating;

    public ShortcutEditorView(ShortcutModel model) {
        this.model = model;
        this.assignedLabelFomat = new MessageFormat(this.getString(BASED_ON_LABEL));
    }

    private void initComponents() {
        this.tabButton = new JButton(this.model.getTabAction());
        this.clearButton = new JButton(this.model.getClearAction());
        this.field = new ShortcutEditorField(40);
        this.assignedCommandLabel = new JLabel();
        this.assignedCommandLabel.setForeground(Color.RED);
        this.updateView();
    }

    private void initEventHandling() {
        this.field.addActionListener(this);
        this.model.addPropertyChangeListener(this);
    }

    @Override
    protected JComponent buildComponent() {
        this.initComponents();
        this.initEventHandling();
        FormLayout layout = new FormLayout("p, 6dlu, fill:p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append(this.getString(SHORTCUT_LABEL), (Component)this.field);
        builder.append((Component)this.assignedCommandLabel, 3);
        builder.append((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)this.tabButton, (JButton)this.clearButton), 3);
        builder.getPanel().setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        return builder.getPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent ignored) {
        if (this.updating) {
            return;
        }
        try {
            this.updating = true;
            this.updateView();
        }
        finally {
            this.updating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.model.setShortcut(this.field.getShortcut());
            this.updateView();
        }
        finally {
            this.updating = false;
        }
    }

    private void updateView() {
        this.field.setShortcut(this.model.getShortcut());
        String assignedCommand = this.model.getAssignedCommand();
        if (assignedCommand == null) {
            this.assignedCommandLabel.setText(" ");
        } else {
            this.assignedCommandLabel.setText(this.assignedLabelFomat.format(new Object[]{assignedCommand}));
        }
    }
}

