/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.view;

import chemaxon.marvin.uif.action.support.ToggleButtonBinding;
import chemaxon.marvin.uif.dialog.model.ItemGroupModel;
import chemaxon.marvin.uif.dialog.model.ToolBarManagerModel;
import chemaxon.marvin.uif.dialog.view.CustomFormBuilder;
import chemaxon.marvin.uif.dialog.view.ItemRenderer;
import chemaxon.marvin.uif.dialog.view.ItemTableAdapter;
import chemaxon.marvin.uif.dialog.view.ViewUtils;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.util.swing.AbstractView;
import chemaxon.marvin.uif.util.swing.PopupButton;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class ToolBarView
extends AbstractView {
    private ResourceBundle bundle;
    private final ToolBarManagerModel model;
    private final ItemGroupModel toolbarModel;
    private JComboBox menuComboBox;
    private JButton newMenuButton;
    private JTable contentList;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton addButton;
    private PopupButton modifyButton;
    private PopupButton menuButton;
    private JTextArea detailsArea;
    private JCheckBox largeIcons;

    public ToolBarView(ToolBarManagerModel model) {
        this.model = model;
        this.toolbarModel = model.getSelectedToolBarModel();
        this.bundle = ResourceBundle.getBundle(ToolBarView.class.getName());
    }

    private void initComponents() {
        this.menuComboBox = new JComboBox(this.model.getToolBarSelector());
        this.menuComboBox.setRenderer(new ToolBarRenderer());
        this.newMenuButton = new JButton(this.model.getNewAction());
        this.menuButton = new PopupButton(this.bundle.getString("toolbar.name"));
        this.menuButton.getPopupMenu().add(this.model.getRenameAction());
        if (this.model.getCanAddDelete()) {
            this.menuButton.getPopupMenu().add(this.model.getDeleteAction());
        }
        this.menuButton.getPopupMenu().addSeparator();
        this.menuButton.getPopupMenu().add(this.createRadio(this.model.getIconStyleAction()));
        this.menuButton.getPopupMenu().add(this.createRadio(this.model.getTextStyleAction()));
        this.menuButton.getPopupMenu().add(this.createRadio(this.model.getIconAndTextStyleAction()));
        this.largeIcons = new JCheckBox(this.bundle.getString("largeicons.label")){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.contentList = new JTable(new ItemTableAdapter(this.toolbarModel.getListModel())){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension result = super.getPreferredScrollableViewportSize();
                result.height = 8 * this.getRowHeight();
                return result;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                Container viewPort = this.getParent();
                if (!(viewPort instanceof JViewport)) {
                    return false;
                }
                return this.getPreferredSize().height < viewPort.getHeight();
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (row >= this.getRowCount() || column > this.getColumnCount() || this.getValueAt(row, column) == null) {
                    return this.getDefaultRenderer(Object.class);
                }
                return super.getCellRenderer(row, column);
            }
        };
        this.contentList.setSelectionModel(this.toolbarModel.getSelectionModel());
        ItemRenderer itemRenderer = new ItemRenderer(this.toolbarModel.getProvider());
        this.contentList.setDefaultRenderer(Item.class, itemRenderer);
        this.contentList.setTableHeader(null);
        this.contentList.setColumnSelectionAllowed(false);
        this.contentList.getColumnModel().setColumnMargin(2);
        this.contentList.getColumnModel().getColumn(0).setMaxWidth(this.contentList.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this.contentList, (Object)Boolean.TRUE, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width + 4);
        this.contentList.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "toggle");
        this.contentList.getActionMap().put("toggle", new ToggleAction());
        this.contentList.setRowHeight(this.contentList.getRowMargin() + itemRenderer.getTableCellRendererComponent((JTable)this.contentList, null, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
        this.contentList.setShowHorizontalLines(false);
        this.contentList.doLayout();
        this.contentList.setPreferredScrollableViewportSize(this.contentList.getPreferredSize());
        this.moveUpButton = new JButton(this.toolbarModel.getMoveUpAction());
        this.moveDownButton = new JButton(this.toolbarModel.getMoveDownAction());
        this.addButton = new JButton(this.toolbarModel.getAddAction());
        this.modifyButton = new PopupButton(this.bundle.getString("modify.name"));
        this.modifyButton.getPopupMenu().add(this.toolbarModel.getRenameAction());
        this.modifyButton.getPopupMenu().add(this.toolbarModel.getDeleteAction());
        this.modifyButton.getPopupMenu().addSeparator();
        this.modifyButton.getPopupMenu().add(this.toolbarModel.getAddSeparatorAction());
        this.detailsArea = new JTextArea(this.toolbarModel.getDescription(), 3, 40);
        this.detailsArea.setEditable(false);
        this.detailsArea.setOpaque(false);
        this.detailsArea.setWrapStyleWord(true);
        this.detailsArea.setLineWrap(true);
        this.updateView();
    }

    private Component createRadio(Action action) {
        JRadioButtonMenuItem button = new JRadioButtonMenuItem(action);
        ToggleButtonBinding.bind(button, action);
        return button;
    }

    private void initEventHandling() {
        this.contentList.getSelectionModel().addListSelectionListener(new SelectionChangeHandler());
        this.largeIcons.addItemListener(new ItemChangeHandler());
    }

    @Override
    protected JComponent buildComponent() {
        this.initComponents();
        this.initEventHandling();
        CustomFormBuilder builder = ViewUtils.createFormBuilder();
        CellConstraints cc = new CellConstraints();
        builder.appendSeparator(this.bundle.getString("toolbars.label"));
        builder.append(this.bundle.getString("toolbar.label"), (Component)this.menuComboBox);
        JButton first = this.model.getCanAddDelete() ? this.newMenuButton : this.menuButton;
        PopupButton second = this.model.getCanAddDelete() ? this.menuButton : null;
        builder.append(first);
        builder.append("", (Component)this.largeIcons, (Component)second);
        builder.appendSeparator(this.getString("contents.label"));
        builder.append(this.getString("entries.label"), null, (Component)this.addButton);
        builder.append("", null, (Component)this.moveUpButton);
        builder.append("", null, (Component)this.moveDownButton);
        builder.append("", null, (Component)this.modifyButton);
        builder.nextLine(-6);
        builder.nextColumn(2);
        builder.setRowGroupingEnabled(false);
        builder.appendRow("p:grow");
        builder.add(new JScrollPane(this.contentList), cc.xywh(builder.getColumn(), builder.getRow(), 1, 8));
        builder.nextLine(builder.getRowCount() - builder.getRow() + 1);
        builder.appendSeparator(this.getString("details.label"));
        builder.append((Component)new JScrollPane(this.detailsArea), builder.getColumnCount() - builder.getLeadingColumnOffset());
        this.model.setComponent(builder.getPanel());
        this.toolbarModel.setComponent(builder.getPanel());
        return builder.getPanel();
    }

    private void updateView() {
        this.detailsArea.setText(this.toolbarModel.getDescription());
        this.largeIcons.setSelected(this.model.getUseLargeIcons());
    }

    private class ToggleAction
    extends AbstractAction {
        private ToggleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = ToolBarView.this.contentList.getSelectedRow();
            if (selectedRow != -1) {
                Boolean selected = (Boolean)ToolBarView.this.contentList.getValueAt(selectedRow, 0);
                ToolBarView.this.contentList.setValueAt(selected == false, selectedRow, 0);
            }
        }

        @Override
        public boolean isEnabled() {
            return ToolBarView.this.contentList.getSelectedRow() != -1;
        }
    }

    private class ToolBarRenderer
    extends DefaultListCellRenderer {
        private ToolBarRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Item item = (Item)value;
            String name = item != null && item.getDisplayProperties() != null ? item.getDisplayProperties().getDisplayName() : "";
            return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        }
    }

    private class ItemChangeHandler
    implements ItemListener {
        private ItemChangeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ToolBarView.this.model.setUseLargeIcons(ToolBarView.this.largeIcons.isSelected());
        }
    }

    private class SelectionChangeHandler
    implements ListSelectionListener {
        private SelectionChangeHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ToolBarView.this.updateView();
        }
    }
}

