/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.model;

import chemaxon.marvin.uif.model.AbstractItem;
import chemaxon.marvin.uif.model.DefaultItem;
import chemaxon.marvin.uif.model.DefaultToolbarGroup;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.GroupEvent;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ItemGroupListener;
import chemaxon.marvin.uif.model.Separator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DefaultItemGroup
extends AbstractItem
implements ItemGroup {
    private static final long serialVersionUID = 0L;
    private transient EventListenerList listenerList;
    private List<Item> commands = new ArrayList<Item>(3);

    public DefaultItemGroup() {
        this(null);
    }

    public DefaultItemGroup(String id) {
        this(id, (String)null);
    }

    public DefaultItemGroup(String id, DisplayProperties properties) {
        super(id, properties);
        this.listenerList = new EventListenerList();
    }

    public DefaultItemGroup(String id, String name) {
        this(id, new DisplayProperties(name));
    }

    protected boolean isAllowed(Item item) {
        return true;
    }

    @Override
    public void addItemGroupListener(ItemGroupListener listener) {
        this.listenerList.add(ItemGroupListener.class, listener);
    }

    @Override
    public void removeItemGroupListener(ItemGroupListener listener) {
        this.listenerList.remove(ItemGroupListener.class, listener);
    }

    protected void fireEvent(GroupEvent e) {
        ItemGroupListener[] listeners = (ItemGroupListener[])this.listenerList.getListeners(ItemGroupListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (e.getID() == 0) {
                listeners[i].itemAdded(e);
                continue;
            }
            if (e.getID() == 1) {
                listeners[i].itemRemoved(e);
                continue;
            }
            listeners[i].itemMoved(e);
        }
    }

    protected void fireCommandAdded(Item command) {
        this.fireEvent(new GroupEvent(this, 0, command));
    }

    protected void fireCommandRemoved(Item command) {
        this.fireEvent(new GroupEvent(this, 1, command));
    }

    protected void fireCommandMoved(Item command) {
        this.fireEvent(new GroupEvent(this, 2, command));
    }

    protected void handleAdd(Item command) {
        command.setParent(this);
        this.fireCommandAdded(command);
    }

    protected void handleRemove(Item command) {
        command.setParent(null);
        this.fireCommandRemoved(command);
    }

    @Override
    public int getItemCount() {
        return this.commands.size();
    }

    @Override
    public void add(Item command) {
        this.add(command, this.getItemCount());
    }

    @Override
    public void add(Item command, int index) {
        if (this.isAllowed(command)) {
            this.commands.add(index, command);
            this.handleAdd(command);
        }
    }

    @Override
    public void addAfter(String id, Item command) {
        this.addImpl(id, command, 1);
    }

    @Override
    public void addBefore(String id, Item command) {
        this.addImpl(id, command, 0);
    }

    public void addImpl(String anchor, Item command, int delta) {
        int index = this.indexOf(anchor);
        if (index == -1) {
            throw new IllegalArgumentException("No such item");
        }
        this.add(command, index + delta);
    }

    @Override
    public void move(int from, int to) {
        Item command = this.getItem(from);
        this.commands.remove(command);
        this.commands.add(to, command);
        this.fireCommandMoved(command);
    }

    @Override
    public void remove(Item command) {
        if (command == null) {
            return;
        }
        if (this.commands.remove(command)) {
            this.handleRemove(command);
        }
    }

    @Override
    public void remove(String id) {
        this.remove(this.getItem(id));
    }

    @Override
    public void removeAll() {
        if (this.getItemCount() == 0) {
            return;
        }
        Item[] array = this.commands.toArray(new Item[this.getItemCount()]);
        for (int i = 0; i < array.length; ++i) {
            this.remove(array[i]);
        }
    }

    @Override
    public Item getItem(int index) {
        return this.commands.get(index);
    }

    @Override
    public Item getItem(String id) {
        int index = this.indexOf(id);
        if (index != -1) {
            return this.getItem(index);
        }
        return null;
    }

    @Override
    public int indexOf(String id) {
        if (id == null) {
            return -1;
        }
        for (int i = 0; i < this.commands.size(); ++i) {
            if (!id.equals(this.getItem(i).getID())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(Item command) {
        if (command == null) {
            return -1;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!command.equals(this.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public Item addSeparator() {
        Item result = Separator.createSeparatorFor(this);
        this.add(result);
        return result;
    }

    @Override
    public final boolean isSeparator() {
        return false;
    }

    @Override
    public Item clone() {
        DefaultItemGroup result = (DefaultItemGroup)super.clone();
        result.listenerList = new EventListenerList();
        result.commands = new ArrayList<Item>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            Item clone = (Item)this.getItem(i).clone();
            clone.setParent(result);
            result.commands.add(clone);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DefaultItemGroup other = (DefaultItemGroup)obj;
        return ((Object)this.commands).equals(other.commands);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            AbstractItem item;
            int type = in.read();
            switch (type) {
                case 0: {
                    item = new DefaultItem();
                    break;
                }
                case 1: {
                    item = new Separator();
                    break;
                }
                case 2: {
                    item = new DefaultItemGroup();
                    break;
                }
                case 3: {
                    item = new DefaultToolbarGroup();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type " + type);
                }
            }
            item.readExternal(in);
            this.commands.add(item);
            item.setParent(this);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.commands.size());
        for (Item item : this.commands) {
            if (item instanceof DefaultItem) {
                out.write(0);
            } else if (item instanceof Separator) {
                out.write(1);
            } else if (item instanceof DefaultItemGroup) {
                out.write(2);
            } else if (item instanceof DefaultToolbarGroup) {
                out.write(3);
            } else {
                throw new RuntimeException("Unknown type " + item.getClass());
            }
            ((AbstractItem)item).writeExternal(out);
        }
    }
}

