/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.module.support;

import chemaxon.marvin.uif.model.DefaultItemGroup;
import chemaxon.marvin.uif.model.DefaultToolbarGroup;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.RegistryEvent;
import chemaxon.marvin.uif.model.RegistryListener;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.util.SerialUtils;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.bean.Model;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class DefaultGUIRegistry
extends Model
implements GUIRegistry,
Externalizable {
    private static final long serialVersionUID = 0L;
    private boolean useLargeIcons;
    private String parentID;
    private String id;
    private String name;
    private EventListenerList listenerList;
    private ItemGroup menuBar;
    private Map<String, ItemGroup> popups;
    private Map<String, ToolBarGroup> toolBars;

    public DefaultGUIRegistry() {
        this(null);
    }

    public DefaultGUIRegistry(String id) {
        this.id = id;
        this.parentID = null;
        this.popups = new HashMap<String, ItemGroup>();
        this.toolBars = new HashMap<String, ToolBarGroup>();
        this.listenerList = new EventListenerList();
        this.useLargeIcons = true;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getParentID() {
        return this.parentID;
    }

    @Override
    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setDisplayName(String name) {
        this.name = name;
    }

    @Override
    public ItemGroup getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void setMenuBar(ItemGroup menuBar) {
        if (Utils.equals(this.menuBar, menuBar)) {
            return;
        }
        if (this.menuBar != null) {
            ItemGroup oldMenuBar = this.menuBar;
            this.menuBar = null;
            this.fireMenuBarRemoved(oldMenuBar);
        }
        this.menuBar = menuBar;
        if (menuBar != null) {
            this.fireMenuBarAdded(this.menuBar);
        }
    }

    @Override
    public ItemGroup getPopup(String id) {
        return this.popups.get(id);
    }

    @Override
    public void addPopup(ItemGroup popup) {
        if (this.getPopup(popup.getID()) != null) {
            throw new IllegalArgumentException("Popup with " + popup.getID() + " id already registered!");
        }
        this.popups.put(popup.getID(), popup);
        this.firePopupAdded(popup);
    }

    @Override
    public void removePopup(String id) {
        ItemGroup group = this.getPopup(id);
        if (group != null) {
            this.popups.remove(id);
            this.firePopupRemoved(group);
        }
    }

    @Override
    public ToolBarGroup getToolBar(String id) {
        return this.toolBars.get(id);
    }

    @Override
    public void removeToolBar(String id) {
        ToolBarGroup group = this.getToolBar(id);
        if (group != null) {
            this.toolBars.remove(id);
            this.fireToolBarRemoved(group);
        }
    }

    @Override
    public void addToolBar(ToolBarGroup toolBar) {
        if (this.getToolBar(toolBar.getID()) != null) {
            throw new IllegalArgumentException("ToolBar with " + toolBar.getID() + " id already registered!");
        }
        this.toolBars.put(toolBar.getID(), toolBar);
        this.fireToolBarAdded(toolBar);
    }

    @Override
    public GUIRegistry clone() {
        DefaultGUIRegistry result = (DefaultGUIRegistry)super.clone();
        if (this.menuBar != null) {
            result.menuBar = (ItemGroup)this.menuBar.clone();
        }
        result.popups = DefaultGUIRegistry.cloneMap(this.popups);
        result.toolBars = DefaultGUIRegistry.cloneMap(this.toolBars);
        result.listenerList = new EventListenerList();
        return result;
    }

    private static <V extends ItemGroup> Map<String, V> cloneMap(Map<String, V> map) {
        HashMap<String, ItemGroup> result = new HashMap<String, ItemGroup>();
        for (String key : map.keySet()) {
            result.put(key, (ItemGroup)((ItemGroup)map.get(key)).clone());
        }
        return result;
    }

    @Override
    public String[] getPopupIDs() {
        return this.popups.keySet().toArray(new String[this.popups.size()]);
    }

    @Override
    public String[] getToolBarIDs() {
        return this.toolBars.keySet().toArray(new String[this.toolBars.size()]);
    }

    protected void fireToolBarAdded(ItemGroup group) {
        RegistryListener[] listeners = (RegistryListener[])this.listenerList.getListeners(RegistryListener.class);
        RegistryEvent e = new RegistryEvent(this, group);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].toolBarAdded(e);
        }
    }

    protected void fireToolBarRemoved(ItemGroup group) {
        RegistryListener[] listeners = (RegistryListener[])this.listenerList.getListeners(RegistryListener.class);
        RegistryEvent e = new RegistryEvent(this, group);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].toolBarRemoved(e);
        }
    }

    protected void fireMenuBarRemoved(ItemGroup group) {
        RegistryListener[] listeners = (RegistryListener[])this.listenerList.getListeners(RegistryListener.class);
        RegistryEvent e = new RegistryEvent(this, group);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].menuBarRemoved(e);
        }
    }

    protected void fireMenuBarAdded(ItemGroup group) {
        RegistryListener[] listeners = (RegistryListener[])this.listenerList.getListeners(RegistryListener.class);
        RegistryEvent e = new RegistryEvent(this, group);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].menuBarAdded(e);
        }
    }

    protected void firePopupAdded(ItemGroup group) {
        RegistryListener[] listeners = (RegistryListener[])this.listenerList.getListeners(RegistryListener.class);
        RegistryEvent e = new RegistryEvent(this, group);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].popupAdded(e);
        }
    }

    protected void firePopupRemoved(ItemGroup group) {
        RegistryListener[] listeners = (RegistryListener[])this.listenerList.getListeners(RegistryListener.class);
        RegistryEvent e = new RegistryEvent(this, group);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].popupRemoved(e);
        }
    }

    @Override
    public void addRegistryListener(RegistryListener l) {
        this.listenerList.add(RegistryListener.class, l);
    }

    @Override
    public void removeRegistryListener(RegistryListener l) {
        this.listenerList.remove(RegistryListener.class, l);
    }

    @Override
    public RegistryListener[] getRegistryListeners() {
        return (RegistryListener[])this.listenerList.getListeners(RegistryListener.class);
    }

    @Override
    public boolean getUseLargeIcons() {
        return this.useLargeIcons;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultGUIRegistry)) {
            return false;
        }
        DefaultGUIRegistry other = (DefaultGUIRegistry)obj;
        return (this.id == other.id || this.id != null && this.id.equals(other.id)) && (this.parentID == other.parentID || this.parentID != null && this.parentID.equals(other.parentID)) && (this.name == other.name || this.name != null && this.name.equals(other.name)) && (this.menuBar == other.menuBar || this.menuBar != null && this.menuBar.equals(other.menuBar)) && (this.popups == other.popups || this.popups != null && ((Object)this.popups).equals(other.popups)) && (this.toolBars == other.toolBars || this.toolBars != null && ((Object)this.toolBars).equals(other.toolBars));
    }

    @Override
    public void setUseLargeIcons(boolean useLargeIcons) {
        if (this.getUseLargeIcons() == useLargeIcons) {
            return;
        }
        boolean oldValue = this.getUseLargeIcons();
        this.useLargeIcons = useLargeIcons;
        this.firePropertyChange("useLargeIcons", oldValue, this.getUseLargeIcons());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = SerialUtils.readString(in);
        this.parentID = SerialUtils.readString(in);
        this.name = SerialUtils.readString(in);
        this.useLargeIcons = in.readBoolean();
        if (in.readBoolean()) {
            DefaultItemGroup group = new DefaultItemGroup();
            group.readExternal(in);
            this.menuBar = group;
        }
        int popupCount = in.read();
        for (int i = 0; i < popupCount; ++i) {
            String id = in.readUTF();
            DefaultItemGroup group = new DefaultItemGroup();
            group.readExternal(in);
            this.popups.put(id, group);
        }
        int toolbarCount = in.read();
        for (int i = 0; i < toolbarCount; ++i) {
            String id = in.readUTF();
            DefaultToolbarGroup group = new DefaultToolbarGroup();
            group.readExternal(in);
            this.toolBars.put(id, group);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.id);
        SerialUtils.writeString(out, this.parentID);
        SerialUtils.writeString(out, this.name);
        out.writeBoolean(this.useLargeIcons);
        out.writeBoolean(this.menuBar != null);
        if (this.menuBar != null) {
            ((DefaultItemGroup)this.menuBar).writeExternal(out);
        }
        out.write(this.popups.size());
        for (String id : this.popups.keySet()) {
            out.writeUTF(id);
            ((DefaultItemGroup)this.popups.get(id)).writeExternal(out);
        }
        out.write(this.toolBars.size());
        for (String id : this.toolBars.keySet()) {
            out.writeUTF(id);
            ((DefaultToolbarGroup)this.toolBars.get(id)).writeExternal(out);
        }
    }
}

