/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.resource;

import chemaxon.marvin.uif.resource.IconRepository;
import chemaxon.marvin.uif.util.swing.NullIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LazyIcon
extends ImageIcon {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(LazyIcon.class.getName());
    private transient ImageIcon delegate;
    private String resource;

    public LazyIcon(String resource) {
        this.resource = resource;
    }

    public static Icon createIcon(String resource) {
        if (resource == null) {
            return null;
        }
        return new LazyIcon(resource);
    }

    @Override
    public int getIconHeight() {
        this.ensureLoaded();
        return this.delegate.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        this.ensureLoaded();
        return this.delegate.getIconWidth();
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.ensureLoaded();
        this.delegate.paintIcon(c, g, x, y);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        this.ensureLoaded();
        return this.delegate.getAccessibleContext();
    }

    @Override
    public String getDescription() {
        this.ensureLoaded();
        return this.delegate.getDescription();
    }

    @Override
    public Image getImage() {
        this.ensureLoaded();
        return this.delegate.getImage();
    }

    @Override
    public int getImageLoadStatus() {
        this.ensureLoaded();
        return this.delegate.getImageLoadStatus();
    }

    @Override
    public ImageObserver getImageObserver() {
        this.ensureLoaded();
        return this.delegate.getImageObserver();
    }

    @Override
    public void setDescription(String description) {
        this.ensureLoaded();
        this.delegate.setDescription(description);
    }

    @Override
    public void setImage(Image image) {
        this.ensureLoaded();
        this.delegate.setImage(image);
    }

    @Override
    public void setImageObserver(ImageObserver observer) {
        this.ensureLoaded();
        this.delegate.setImageObserver(observer);
    }

    private synchronized void ensureLoaded() {
        if (this.delegate == null) {
            Icon icon = IconRepository.getIcon(this.resource);
            if (icon instanceof ImageIcon) {
                this.delegate = (ImageIcon)icon;
            } else {
                if (icon == null) {
                    logger.warning("Missing Resource: " + this.resource);
                    icon = new NullIcon(16, 16);
                }
                this.delegate = new ImageIcon(this.convertImage(icon));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage convertImage(Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(null, g, 0, 0);
        }
        catch (Throwable ignored) {
        }
        finally {
            g.dispose();
        }
        return image;
    }
}

