/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.shortcut;

import chemaxon.marvin.uif.shortcut.Shortcut;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class KeyboardShortcut
implements Shortcut {
    private final KeyStroke keyStroke;

    public KeyboardShortcut(KeyStroke keyStroke) {
        if (keyStroke == null) {
            throw new NullPointerException("Keystroke cannot be null!");
        }
        this.keyStroke = keyStroke;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    @Override
    public String getName() {
        String modifiers = KeyEvent.getKeyModifiersText(this.keyStroke.getModifiers());
        String keyText = KeyEvent.getKeyText(this.keyStroke.getKeyCode());
        StringBuffer result = new StringBuffer();
        result.append(modifiers);
        if (result.length() > 0 && keyText.length() > 0) {
            result.append("+");
        }
        result.append(keyText);
        return result.toString();
    }

    public int hashCode() {
        return this.keyStroke.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyboardShortcut)) {
            return false;
        }
        KeyboardShortcut s = (KeyboardShortcut)obj;
        return this.keyStroke.equals(s.keyStroke);
    }

    public String toString() {
        return this.getName();
    }
}

