/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.shortcut;

import chemaxon.marvin.uif.shortcut.Shortcut;
import chemaxon.marvin.uif.shortcut.ShortcutScheme;
import chemaxon.marvin.uif.util.PublicCloneable;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.bean.Model;
import java.util.Map;

public final class ShortcutManager
extends Model
implements PublicCloneable<ShortcutManager> {
    public static final String PROPERTY_ACTIVE_SHORTCUT_SET = "activeShortcutSet";
    public static final String PROPERTY_ACTIVE = "active";
    private String activeSetID;
    private Map<String, ShortcutScheme> schemes = Utils.newLinkedHashMap();

    public void clear() {
        this.setActive(null);
        this.schemes.clear();
    }

    public void addShortcutScheme(ShortcutScheme scheme) {
        if (scheme == null) {
            throw new NullPointerException("Scheme cannot be null!");
        }
        if (this.schemes.containsKey(scheme.getID())) {
            throw new IllegalArgumentException("ShortcutSchema with " + scheme.getID() + " id already registered!");
        }
        if (scheme.getParent() != null && !this.hasShortcutSchema(scheme.getParent().getID())) {
            throw new IllegalArgumentException("Missing parent schema for schema " + scheme.getID() + "!");
        }
        this.schemes.put(scheme.getID(), scheme);
        if (this.activeSetID == null) {
            this.setActive(scheme.getID());
        }
    }

    public boolean canRemove(ShortcutScheme schema) {
        return schema.isEditable() && this.hasShortcutSchema(schema.getID()) && !this.isParent(schema.getID()) && this.schemes.size() > 1;
    }

    public void removeShortcutSchema(String id) {
        if (id == null) {
            throw new NullPointerException("Id cannot be null!");
        }
        if (!this.hasShortcutSchema(id)) {
            return;
        }
        if (this.isParent(id)) {
            throw new IllegalArgumentException("Cannot delete a parent schema!");
        }
        this.schemes.remove(id);
        if (this.activeSetID != null && this.activeSetID.equals(id)) {
            String firstID = !this.schemes.isEmpty() ? this.schemes.keySet().iterator().next() : null;
            this.setActive(firstID);
        }
    }

    private boolean isParent(String id) {
        ShortcutScheme parent = this.getShortcutScheme(id);
        if (parent == null) {
            return false;
        }
        for (ShortcutScheme schema : this.schemes.values()) {
            if (!parent.equals(schema.getParent())) continue;
            return true;
        }
        return false;
    }

    public boolean hasShortcutSchema(String id) {
        return this.schemes.containsKey(id);
    }

    public String[] getShortcutSchemaIDs() {
        return this.schemes.keySet().toArray(new String[this.schemes.keySet().size()]);
    }

    public ShortcutScheme[] getShortcutSchemes() {
        return this.schemes.values().toArray(new ShortcutScheme[this.schemes.values().size()]);
    }

    public ShortcutScheme getActiveShortcutScheme() {
        return this.getShortcutScheme(this.activeSetID);
    }

    public ShortcutScheme getShortcutScheme(String id) {
        if (id == null) {
            return null;
        }
        return this.schemes.get(id);
    }

    public void setActive(String id) {
        if (id != null && !this.hasShortcutSchema(id) || Utils.equals(id, this.activeSetID)) {
            return;
        }
        String oldID = this.activeSetID;
        ShortcutScheme oldValue = this.getActiveShortcutScheme();
        if (oldValue != null) {
            oldValue.setActive(false);
        }
        this.activeSetID = id;
        if (this.getActiveShortcutScheme() != null) {
            this.getActiveShortcutScheme().setActive(true);
        }
        this.firePropertyChange(PROPERTY_ACTIVE, oldID, this.getActive());
        this.firePropertyChange(PROPERTY_ACTIVE_SHORTCUT_SET, oldValue, this.getActiveShortcutScheme());
    }

    public String getActive() {
        return this.activeSetID;
    }

    @Override
    public ShortcutManager clone() {
        ShortcutManager klone = (ShortcutManager)super.clone();
        klone.schemes = Utils.newLinkedHashMap();
        for (ShortcutScheme scheme : this.schemes.values()) {
            ShortcutScheme newScheme = new ShortcutScheme(klone.getShortcutScheme(scheme.getParentID()), scheme.getID(), scheme.getName());
            Shortcut[] shortcuts = newScheme.getOverridenShortcuts();
            for (int i = 0; i < shortcuts.length; ++i) {
                String commandID = scheme.getCommandID(shortcuts[i]);
                if (commandID != null) {
                    newScheme.addShortcut(scheme.getCommandID(shortcuts[i]), shortcuts[i]);
                    continue;
                }
                newScheme.removeShortcut(shortcuts[i]);
            }
            klone.addShortcutScheme(newScheme);
        }
        klone.setActive(this.activeSetID);
        return klone;
    }
}

