/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.shortcut;

import chemaxon.marvin.uif.shortcut.Shortcut;
import chemaxon.marvin.uif.shortcut.ShortcutEvent;
import chemaxon.marvin.uif.shortcut.ShortcutListener;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.bean.Model;
import chemaxon.marvin.uif.util.listener.AbstractWeakListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class ShortcutScheme
extends Model {
    private static final long serialVersionUID = 1L;
    public static String PROPERTY_ACTIVE = "active";
    public static String PROPERTY_NAME = "name";
    public static String PROPERTY_EDITABLE = "editable";
    private final ShortcutScheme parent;
    private final String id;
    private String name;
    private boolean editable;
    private boolean active;
    private Map<Shortcut, String> localShortcuts;
    private Map<String, List<Shortcut>> reverseMapping;
    private EventListenerList listenerList;

    public ShortcutScheme(String id, String name) {
        this(null, id, name);
    }

    public ShortcutScheme(ShortcutScheme parent, String id, String name) {
        this.parent = parent;
        this.id = id;
        this.name = name;
        this.localShortcuts = Utils.newLinkedHashMap();
        this.reverseMapping = Utils.newMap();
        this.listenerList = new EventListenerList();
        this.editable = true;
        if (parent != null) {
            parent.addShortcutListener(new ParentHandler(this, parent));
        }
    }

    private void checkEditable() throws IllegalStateException {
        if (!this.isEditable()) {
            throw new IllegalStateException("ShortcutSet is read-only!");
        }
    }

    protected void fireShortcutEvent(ShortcutEvent e) {
        ShortcutListener[] listeners = (ShortcutListener[])this.listenerList.getListeners(ShortcutListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].shortcutChanged(e);
        }
    }

    protected void fireShortcutRemoved(String commandID, Shortcut shortcut) {
        this.fireShortcutEvent(new ShortcutEvent(this, 2, commandID, shortcut));
    }

    protected void fireShortcutAdded(String commandID, Shortcut shortcut) {
        this.fireShortcutEvent(new ShortcutEvent(this, 1, commandID, shortcut));
    }

    public void addShortcutListener(ShortcutListener listener) {
        this.listenerList.add(ShortcutListener.class, listener);
    }

    public void removeShortcutListener(ShortcutListener listener) {
        this.listenerList.remove(ShortcutListener.class, listener);
    }

    public Shortcut[] getOverridenShortcuts() {
        return this.localShortcuts.keySet().toArray(new Shortcut[this.localShortcuts.keySet().size()]);
    }

    private boolean isLocallyRemoved(Shortcut shortcut) {
        return this.isLocallyDefined(shortcut) && this.localShortcuts.get(shortcut) == null;
    }

    public boolean isLocallyDefined(Shortcut shortcut) {
        return this.localShortcuts.containsKey(shortcut);
    }

    public boolean isCommandLocallyBound(String commandID) {
        return this.reverseMapping.containsKey(commandID);
    }

    public boolean isCommandBound(String commandID) {
        return this.reverseMapping.containsKey(commandID) || this.parent != null && this.parent.isCommandBound(commandID);
    }

    public boolean isOverriden(String commandID) {
        if (this.parent == null) {
            return false;
        }
        if (this.reverseMapping.containsKey(commandID)) {
            return true;
        }
        Object[] original = this.parent.getShortcuts(commandID);
        Object[] current = this.getShortcuts(commandID);
        return Arrays.equals(original, current);
    }

    public void setName(String name) {
        this.checkEditable();
        String oldValue = this.getName();
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldValue, this.getName());
    }

    public String getName() {
        return this.name;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        boolean oldValue = this.isEditable();
        this.editable = editable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldValue, this.isEditable());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean oldValue = this.isActive();
        this.active = active;
        this.firePropertyChange(PROPERTY_ACTIVE, oldValue, this.isActive());
    }

    public ShortcutScheme getParent() {
        return this.parent;
    }

    public String getParentID() {
        return this.parent != null ? this.parent.getID() : null;
    }

    public String getID() {
        return this.id;
    }

    public void setShortcut(String commandID, Shortcut shortcut) {
        this.checkEditable();
        Shortcut[] shortcuts = this.getShortcuts(commandID);
        for (int i = 0; i < shortcuts.length; ++i) {
            this.removeShortcut(shortcuts[i]);
        }
        this.addShortcut(commandID, shortcut);
    }

    public void addShortcut(String commandID, Shortcut shortcut) {
        this.checkEditable();
        if (commandID == null) {
            this.removeShortcut(shortcut);
            return;
        }
        String oldCommandID = this.getCommandID(shortcut);
        if (oldCommandID != null && oldCommandID.equals(commandID)) {
            return;
        }
        if (oldCommandID != null && !oldCommandID.equals(commandID)) {
            this.removeShortcut(shortcut);
        }
        if (this.parent == null || this.parent.getCommandID(shortcut) == null || !this.parent.getCommandID(shortcut).equals(commandID)) {
            this.localShortcuts.remove(shortcut);
            this.localShortcuts.put(shortcut, commandID);
            this.addReverseMapping(commandID, shortcut);
        }
        this.fireShortcutAdded(commandID, shortcut);
    }

    private void addReverseMapping(String commandID, Shortcut shortcut) {
        List<Shortcut> list = this.reverseMapping.get(commandID);
        if (list == null) {
            list = Utils.newList();
            this.reverseMapping.put(commandID, list);
        }
        list.add(shortcut);
    }

    private void removeReverseMapping(Shortcut shortcut, String commandID) {
        List<Shortcut> list = this.reverseMapping.get(commandID);
        if (list != null) {
            list.remove(shortcut);
            if (list.isEmpty()) {
                this.reverseMapping.remove(commandID);
            }
        }
    }

    public void removeShortcut(Shortcut shortcut) {
        if (shortcut == null) {
            return;
        }
        this.checkEditable();
        String commandID = this.getCommandID(shortcut);
        if (commandID == null) {
            return;
        }
        this.localShortcuts.remove(shortcut);
        this.localShortcuts.put(shortcut, null);
        this.removeReverseMapping(shortcut, commandID);
        this.fireShortcutRemoved(commandID, shortcut);
    }

    public String getCommandID(Shortcut shortcut) {
        if (this.isLocallyDefined(shortcut)) {
            return this.localShortcuts.get(shortcut);
        }
        return this.parent != null ? this.parent.getCommandID(shortcut) : null;
    }

    public String[] getCommandIDs() {
        HashSet<String> result = new HashSet<String>();
        Shortcut[] shortcuts = this.getShortcuts();
        for (int i = 0; i < shortcuts.length; ++i) {
            result.add(this.getCommandID(shortcuts[i]));
        }
        return result.toArray(new String[result.size()]);
    }

    public Shortcut[] getShortcuts() {
        HashSet<Shortcut> result = new HashSet<Shortcut>();
        if (this.parent != null) {
            Shortcut[] shortcuts = this.parent.getShortcuts();
            for (int i = 0; i < shortcuts.length; ++i) {
                if (this.isLocallyDefined(shortcuts[i])) continue;
                result.add(shortcuts[i]);
            }
        }
        for (Shortcut shortcut : this.localShortcuts.keySet()) {
            if (this.isLocallyRemoved(shortcut)) continue;
            result.add(shortcut);
        }
        return result.toArray(new Shortcut[result.size()]);
    }

    public Shortcut[] getShortcuts(String commandID) {
        List<Shortcut> result = Utils.newList();
        if (this.parent != null) {
            Shortcut[] shortcuts = this.parent.getShortcuts(commandID);
            for (int i = 0; i < shortcuts.length; ++i) {
                if (this.isLocallyDefined(shortcuts[i])) continue;
                result.add(shortcuts[i]);
            }
        }
        if (this.reverseMapping.containsKey(commandID)) {
            result.addAll((Collection)this.reverseMapping.get(commandID));
        }
        return result.toArray(new Shortcut[result.size()]);
    }

    private void handleEvent(ShortcutEvent event) {
        if (!this.isLocallyDefined(event.getShortcut())) {
            this.fireShortcutEvent(new ShortcutEvent(this, event.getType(), event.getCommandID(), event.getShortcut()));
        }
    }

    public String toString() {
        return "ShortcutScheme[" + this.id + "]";
    }

    private static class ParentHandler
    extends AbstractWeakListener
    implements ShortcutListener {
        private static final long serialVersionUID = 1L;

        public ParentHandler(ShortcutScheme target, ShortcutScheme source) {
            super(target, source, ShortcutListener.class);
        }

        @Override
        public void shortcutChanged(ShortcutEvent event) {
            ShortcutScheme target = (ShortcutScheme)this.getTarget();
            if (target != null) {
                target.handleEvent(event);
            }
        }
    }
}

