/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.shortcut;

import chemaxon.marvin.uif.util.Utils;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.KeyStroke;

public class ShortcutUtil {
    public static final String SHIFT_MODIFIER = "shift";
    public static final String ALT_MODIFIER = "alt";
    public static final String META_MODIFIER = "meta";
    public static final String CONTROL_MODIFIER = "control";
    public static final String SHORTCUT_MODIFIER = "shortcut";
    private static Map<Integer, String> codeToName;
    private static Map<String, Integer> nameToCode;

    private ShortcutUtil() {
    }

    private static synchronized void initKeyMaps() {
        codeToName = Utils.newMap();
        nameToCode = Utils.newMap();
        try {
            ShortcutUtil.initKeyMapsFromFields(KeyEvent.class.getFields());
        }
        catch (SecurityException e) {
            ShortcutUtil.initKeyMapsFromConstants();
        }
    }

    static void initKeyMapsFromConstants() {
        codeToName.clear();
        nameToCode.clear();
        ShortcutUtil.addKeyCode("0", 48);
        ShortcutUtil.addKeyCode("1", 49);
        ShortcutUtil.addKeyCode("2", 50);
        ShortcutUtil.addKeyCode("3", 51);
        ShortcutUtil.addKeyCode("4", 52);
        ShortcutUtil.addKeyCode("5", 53);
        ShortcutUtil.addKeyCode("6", 54);
        ShortcutUtil.addKeyCode("7", 55);
        ShortcutUtil.addKeyCode("8", 56);
        ShortcutUtil.addKeyCode("9", 57);
        ShortcutUtil.addKeyCode("A", 65);
        ShortcutUtil.addKeyCode("ACCEPT", 30);
        ShortcutUtil.addKeyCode("ADD", 107);
        ShortcutUtil.addKeyCode("AGAIN", 65481);
        ShortcutUtil.addKeyCode("ALL_CANDIDATES", 256);
        ShortcutUtil.addKeyCode("ALPHANUMERIC", 240);
        ShortcutUtil.addKeyCode("ALT", 18);
        ShortcutUtil.addKeyCode("ALT_GRAPH", 65406);
        ShortcutUtil.addKeyCode("AMPERSAND", 150);
        ShortcutUtil.addKeyCode("ASTERISK", 151);
        ShortcutUtil.addKeyCode("AT", 512);
        ShortcutUtil.addKeyCode("B", 66);
        ShortcutUtil.addKeyCode("BACK_QUOTE", 192);
        ShortcutUtil.addKeyCode("BACK_SLASH", 92);
        ShortcutUtil.addKeyCode("BACK_SPACE", 8);
        ShortcutUtil.addKeyCode("BRACELEFT", 161);
        ShortcutUtil.addKeyCode("BRACERIGHT", 162);
        ShortcutUtil.addKeyCode("C", 67);
        ShortcutUtil.addKeyCode("CANCEL", 3);
        ShortcutUtil.addKeyCode("CAPS_LOCK", 20);
        ShortcutUtil.addKeyCode("CIRCUMFLEX", 514);
        ShortcutUtil.addKeyCode("CLEAR", 12);
        ShortcutUtil.addKeyCode("CLOSE_BRACKET", 93);
        ShortcutUtil.addKeyCode("CODE_INPUT", 258);
        ShortcutUtil.addKeyCode("COLON", 513);
        ShortcutUtil.addKeyCode("COMMA", 44);
        ShortcutUtil.addKeyCode("COMPOSE", 65312);
        ShortcutUtil.addKeyCode("CONTROL", 17);
        ShortcutUtil.addKeyCode("CONVERT", 28);
        ShortcutUtil.addKeyCode("COPY", 65485);
        ShortcutUtil.addKeyCode("CUT", 65489);
        ShortcutUtil.addKeyCode("D", 68);
        ShortcutUtil.addKeyCode("DEAD_ABOVEDOT", 134);
        ShortcutUtil.addKeyCode("DEAD_ABOVERING", 136);
        ShortcutUtil.addKeyCode("DEAD_ACUTE", 129);
        ShortcutUtil.addKeyCode("DEAD_BREVE", 133);
        ShortcutUtil.addKeyCode("DEAD_CARON", 138);
        ShortcutUtil.addKeyCode("DEAD_CEDILLA", 139);
        ShortcutUtil.addKeyCode("DEAD_CIRCUMFLEX", 130);
        ShortcutUtil.addKeyCode("DEAD_DIAERESIS", 135);
        ShortcutUtil.addKeyCode("DEAD_DOUBLEACUTE", 137);
        ShortcutUtil.addKeyCode("DEAD_GRAVE", 128);
        ShortcutUtil.addKeyCode("DEAD_IOTA", 141);
        ShortcutUtil.addKeyCode("DEAD_MACRON", 132);
        ShortcutUtil.addKeyCode("DEAD_OGONEK", 140);
        ShortcutUtil.addKeyCode("DEAD_SEMIVOICED_SOUND", 143);
        ShortcutUtil.addKeyCode("DEAD_TILDE", 131);
        ShortcutUtil.addKeyCode("DEAD_VOICED_SOUND", 142);
        ShortcutUtil.addKeyCode("DECIMAL", 110);
        ShortcutUtil.addKeyCode("DELETE", 127);
        ShortcutUtil.addKeyCode("DIVIDE", 111);
        ShortcutUtil.addKeyCode("DOLLAR", 515);
        ShortcutUtil.addKeyCode("DOWN", 40);
        ShortcutUtil.addKeyCode("E", 69);
        ShortcutUtil.addKeyCode("END", 35);
        ShortcutUtil.addKeyCode("ENTER", 10);
        ShortcutUtil.addKeyCode("EQUALS", 61);
        ShortcutUtil.addKeyCode("ESCAPE", 27);
        ShortcutUtil.addKeyCode("EURO_SIGN", 516);
        ShortcutUtil.addKeyCode("EXCLAMATION_MARK", 517);
        ShortcutUtil.addKeyCode("F", 70);
        ShortcutUtil.addKeyCode("F1", 112);
        ShortcutUtil.addKeyCode("F10", 121);
        ShortcutUtil.addKeyCode("F11", 122);
        ShortcutUtil.addKeyCode("F12", 123);
        ShortcutUtil.addKeyCode("F13", 61440);
        ShortcutUtil.addKeyCode("F14", 61441);
        ShortcutUtil.addKeyCode("F15", 61442);
        ShortcutUtil.addKeyCode("F16", 61443);
        ShortcutUtil.addKeyCode("F17", 61444);
        ShortcutUtil.addKeyCode("F18", 61445);
        ShortcutUtil.addKeyCode("F19", 61446);
        ShortcutUtil.addKeyCode("F2", 113);
        ShortcutUtil.addKeyCode("F20", 61447);
        ShortcutUtil.addKeyCode("F21", 61448);
        ShortcutUtil.addKeyCode("F22", 61449);
        ShortcutUtil.addKeyCode("F23", 61450);
        ShortcutUtil.addKeyCode("F24", 61451);
        ShortcutUtil.addKeyCode("F3", 114);
        ShortcutUtil.addKeyCode("F4", 115);
        ShortcutUtil.addKeyCode("F5", 116);
        ShortcutUtil.addKeyCode("F6", 117);
        ShortcutUtil.addKeyCode("F7", 118);
        ShortcutUtil.addKeyCode("F8", 119);
        ShortcutUtil.addKeyCode("F9", 120);
        ShortcutUtil.addKeyCode("FINAL", 24);
        ShortcutUtil.addKeyCode("FIND", 65488);
        ShortcutUtil.addKeyCode("FULL_WIDTH", 243);
        ShortcutUtil.addKeyCode("G", 71);
        ShortcutUtil.addKeyCode("GREATER", 160);
        ShortcutUtil.addKeyCode("H", 72);
        ShortcutUtil.addKeyCode("HALF_WIDTH", 244);
        ShortcutUtil.addKeyCode("HELP", 156);
        ShortcutUtil.addKeyCode("HIRAGANA", 242);
        ShortcutUtil.addKeyCode("HOME", 36);
        ShortcutUtil.addKeyCode("I", 73);
        ShortcutUtil.addKeyCode("INPUT_METHOD_ON_OFF", 263);
        ShortcutUtil.addKeyCode("INSERT", 155);
        ShortcutUtil.addKeyCode("INVERTED_EXCLAMATION_MARK", 518);
        ShortcutUtil.addKeyCode("J", 74);
        ShortcutUtil.addKeyCode("JAPANESE_HIRAGANA", 260);
        ShortcutUtil.addKeyCode("JAPANESE_KATAKANA", 259);
        ShortcutUtil.addKeyCode("JAPANESE_ROMAN", 261);
        ShortcutUtil.addKeyCode("K", 75);
        ShortcutUtil.addKeyCode("KANA", 21);
        ShortcutUtil.addKeyCode("KANA_LOCK", 262);
        ShortcutUtil.addKeyCode("KANJI", 25);
        ShortcutUtil.addKeyCode("KATAKANA", 241);
        ShortcutUtil.addKeyCode("KP_DOWN", 225);
        ShortcutUtil.addKeyCode("KP_LEFT", 226);
        ShortcutUtil.addKeyCode("KP_RIGHT", 227);
        ShortcutUtil.addKeyCode("KP_UP", 224);
        ShortcutUtil.addKeyCode("L", 76);
        ShortcutUtil.addKeyCode("LEFT", 37);
        ShortcutUtil.addKeyCode("LEFT_PARENTHESIS", 519);
        ShortcutUtil.addKeyCode("LESS", 153);
        ShortcutUtil.addKeyCode("M", 77);
        ShortcutUtil.addKeyCode("META", 157);
        ShortcutUtil.addKeyCode("MINUS", 45);
        ShortcutUtil.addKeyCode("MODECHANGE", 31);
        ShortcutUtil.addKeyCode("MULTIPLY", 106);
        ShortcutUtil.addKeyCode("N", 78);
        ShortcutUtil.addKeyCode("NONCONVERT", 29);
        ShortcutUtil.addKeyCode("NUM_LOCK", 144);
        ShortcutUtil.addKeyCode("NUMBER_SIGN", 520);
        ShortcutUtil.addKeyCode("NUMPAD0", 96);
        ShortcutUtil.addKeyCode("NUMPAD1", 97);
        ShortcutUtil.addKeyCode("NUMPAD2", 98);
        ShortcutUtil.addKeyCode("NUMPAD3", 99);
        ShortcutUtil.addKeyCode("NUMPAD4", 100);
        ShortcutUtil.addKeyCode("NUMPAD5", 101);
        ShortcutUtil.addKeyCode("NUMPAD6", 102);
        ShortcutUtil.addKeyCode("NUMPAD7", 103);
        ShortcutUtil.addKeyCode("NUMPAD8", 104);
        ShortcutUtil.addKeyCode("NUMPAD9", 105);
        ShortcutUtil.addKeyCode("O", 79);
        ShortcutUtil.addKeyCode("OPEN_BRACKET", 91);
        ShortcutUtil.addKeyCode("P", 80);
        ShortcutUtil.addKeyCode("PAGE_DOWN", 34);
        ShortcutUtil.addKeyCode("PAGE_UP", 33);
        ShortcutUtil.addKeyCode("PASTE", 65487);
        ShortcutUtil.addKeyCode("PAUSE", 19);
        ShortcutUtil.addKeyCode("PERIOD", 46);
        ShortcutUtil.addKeyCode("PLUS", 521);
        ShortcutUtil.addKeyCode("PREVIOUS_CANDIDATE", 257);
        ShortcutUtil.addKeyCode("PRINTSCREEN", 154);
        ShortcutUtil.addKeyCode("PROPS", 65482);
        ShortcutUtil.addKeyCode("Q", 81);
        ShortcutUtil.addKeyCode("QUOTE", 222);
        ShortcutUtil.addKeyCode("QUOTEDBL", 152);
        ShortcutUtil.addKeyCode("R", 82);
        ShortcutUtil.addKeyCode("RIGHT", 39);
        ShortcutUtil.addKeyCode("RIGHT_PARENTHESIS", 522);
        ShortcutUtil.addKeyCode("ROMAN_CHARACTERS", 245);
        ShortcutUtil.addKeyCode("S", 83);
        ShortcutUtil.addKeyCode("SCROLL_LOCK", 145);
        ShortcutUtil.addKeyCode("SEMICOLON", 59);
        ShortcutUtil.addKeyCode("SEPARATER", 108);
        ShortcutUtil.addKeyCode("SEPARATOR", 108);
        ShortcutUtil.addKeyCode("SHIFT", 16);
        ShortcutUtil.addKeyCode("SLASH", 47);
        ShortcutUtil.addKeyCode("SPACE", 32);
        ShortcutUtil.addKeyCode("STOP", 65480);
        ShortcutUtil.addKeyCode("SUBTRACT", 109);
        ShortcutUtil.addKeyCode("T", 84);
        ShortcutUtil.addKeyCode("TAB", 9);
        ShortcutUtil.addKeyCode("U", 85);
        ShortcutUtil.addKeyCode("UNDEFINED", 0);
        ShortcutUtil.addKeyCode("UNDERSCORE", 523);
        ShortcutUtil.addKeyCode("UNDO", 65483);
        ShortcutUtil.addKeyCode("UP", 38);
        ShortcutUtil.addKeyCode("V", 86);
        ShortcutUtil.addKeyCode("W", 87);
        ShortcutUtil.addKeyCode("X", 88);
        ShortcutUtil.addKeyCode("Y", 89);
        ShortcutUtil.addKeyCode("Z", 90);
    }

    private static void initKeyMapsFromFields(Field[] fields) {
        int expected_modifiers = 25;
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getModifiers() != expected_modifiers || fields[i].getType() != Integer.TYPE || !fields[i].getName().startsWith("VK_")) continue;
                ShortcutUtil.addKeyCode(fields[i].getName().substring(3), fields[i].getInt(KeyEvent.class));
                continue;
            }
            catch (IllegalAccessException e) {
                System.err.println("Failed to build key cache");
            }
        }
    }

    private static void addKeyCode(String name, int keyCode) {
        Integer key = new Integer(keyCode);
        codeToName.put(key, name);
        nameToCode.put(name, key);
    }

    private static synchronized Map<Integer, String> getCodeToNameMap() {
        if (codeToName == null) {
            ShortcutUtil.initKeyMaps();
        }
        return codeToName;
    }

    private static synchronized Map<String, Integer> getNameToCodeMap() {
        if (nameToCode == null) {
            ShortcutUtil.initKeyMaps();
        }
        return nameToCode;
    }

    public static KeyStroke stringToKey(String str) {
        if (str == null) {
            return null;
        }
        String[] segments = str.split(" ");
        if (segments.length == 0) {
            return null;
        }
        int modifiers = ShortcutUtil.getModifiers(segments);
        Integer keyCode = ShortcutUtil.getNameToCodeMap().get(segments[segments.length - 1].toUpperCase());
        if (keyCode == null) {
            return null;
        }
        return KeyStroke.getKeyStroke(keyCode, modifiers);
    }

    public static String keyToString(KeyStroke key) {
        String keyName;
        if (key == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (ShortcutUtil.addModifiers(result, key.getModifiers())) {
            result.append(' ');
        }
        if ((keyName = ShortcutUtil.getCodeToNameMap().get(new Integer(key.getKeyCode()))) != null) {
            result.append(keyName);
        } else {
            result.append(key.getKeyChar());
        }
        return result.toString();
    }

    private static int getModifiers(String[] segments) {
        int modifier = 0;
        for (int i = 0; i < segments.length - 1; ++i) {
            if (segments[i].equalsIgnoreCase(SHIFT_MODIFIER)) {
                modifier |= 0x40;
                continue;
            }
            if (segments[i].equalsIgnoreCase(CONTROL_MODIFIER)) {
                modifier |= 0x80;
                continue;
            }
            if (segments[i].equalsIgnoreCase(ALT_MODIFIER)) {
                modifier |= 0x200;
                continue;
            }
            if (segments[i].equalsIgnoreCase(META_MODIFIER)) {
                modifier |= 0x100;
                continue;
            }
            if (!segments[i].equalsIgnoreCase(SHORTCUT_MODIFIER)) continue;
            modifier |= GraphicsEnvironment.isHeadless() ? 2 : Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        return modifier;
    }

    private static boolean addModifiers(StringBuffer result, int modifiers) {
        int length = result.length();
        if ((modifiers & 0x80) != 0) {
            result.append(CONTROL_MODIFIER);
            result.append(' ');
        }
        if ((modifiers & 0x200) != 0) {
            result.append(ALT_MODIFIER);
            result.append(' ');
        }
        if ((modifiers & 0x100) != 0) {
            result.append(META_MODIFIER);
            result.append(' ');
        }
        if ((modifiers & 0x40) != 0) {
            result.append(SHIFT_MODIFIER);
            result.append(' ');
        }
        if (result.length() != length) {
            result.deleteCharAt(result.length() - 1);
            return true;
        }
        return false;
    }
}

