/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.KeyStroke;

public final class SerialUtils {
    private SerialUtils() {
    }

    private static void writeDefault(ObjectOutput out, Object o) throws IOException {
        out.writeBoolean(o != null);
    }

    private static boolean readDefault(ObjectInput in) throws IOException {
        return in.readBoolean();
    }

    public static void writeCollection(ObjectOutput out, Collection<?> collection) throws IOException {
        SerialUtils.writeDefault(out, collection);
        if (collection != null) {
            out.writeInt(collection.size());
            for (Object object : collection) {
                out.writeObject(object);
            }
        }
    }

    public static <E> ArrayList<E> readList(ObjectInput in, Class<E> clazz) throws IOException, ClassNotFoundException {
        if (!SerialUtils.readDefault(in)) {
            return null;
        }
        int size = in.readInt();
        ArrayList<E> result = new ArrayList<E>(size);
        for (int i = 0; i < size; ++i) {
            result.add(clazz.cast(in.readObject()));
        }
        return result;
    }

    public static void writeString(ObjectOutput out, String str) throws IOException {
        SerialUtils.writeDefault(out, str);
        if (str != null) {
            out.writeUTF(str);
        }
    }

    public static String readString(ObjectInput in) throws IOException {
        return SerialUtils.readDefault(in) ? in.readUTF() : null;
    }

    public static void writeKeyStroke(ObjectOutput out, KeyStroke ks) throws IOException {
        SerialUtils.writeDefault(out, ks);
        if (ks != null) {
            out.writeInt(ks.getKeyCode());
            out.writeInt(ks.getModifiers());
        }
    }

    public static KeyStroke readKeyStroke(ObjectInput in) throws IOException {
        return SerialUtils.readDefault(in) ? KeyStroke.getKeyStroke(in.readInt(), in.readInt()) : null;
    }

    public static void writeInteger(ObjectOutput out, Integer i) throws IOException {
        SerialUtils.writeDefault(out, i);
        if (i != null) {
            out.writeInt(i);
        }
    }

    public static Integer readInteger(ObjectInput in) throws IOException {
        return SerialUtils.readDefault(in) ? Integer.valueOf(in.readInt()) : null;
    }

    public static void writeBoolean(ObjectOutput out, Boolean b) throws IOException {
        SerialUtils.writeDefault(out, b);
        if (b != null) {
            out.writeBoolean(b);
        }
    }

    public static Boolean readBoolean(ObjectInput in) throws IOException {
        return SerialUtils.readDefault(in) ? Boolean.valueOf(in.readBoolean()) : null;
    }

    public static void writeObject(ObjectOutput out, Object o) throws IOException {
        SerialUtils.writeDefault(out, o);
        if (o != null) {
            out.writeObject(o);
        }
    }

    public static Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        return SerialUtils.readDefault(in) ? in.readObject() : null;
    }
}

