/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.swing;

import chemaxon.marvin.uif.util.Utils;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public abstract class AbstractDialog
extends JDialog {
    private static final long serialVersionUID = 7330132998673101138L;
    private static final Border DEFAULT_BORDER = BorderFactory.createEmptyBorder(8, 12, 12, 12);
    private static final int BUTTON_PANEL_VGAP = 17;
    public static final String OK_LABEL = "ok.label";
    public static final String CLOSE_LABEL = "close.label";
    public static final String APPLY_LABEL = "apply.label";
    public static final String CANCEL_LABEL = "cancel.label";
    public static final String RESET_LABEL = "reset.label";
    private static final String OK = "OK";
    private static final String CLOSE = "Close";
    private static final String APPLY = "Apply";
    private static final String RESET = "Reset";
    private static final String CANCEL = "Cancel";
    private static final Object CLOSE_ACTION_KEY = new Object();
    private ResourceBundle bundle;
    private boolean canceled;
    private boolean closeOnEscape;
    private Action okAction;
    private Action cancelAction;
    private Action applyAction;
    private Action resetAction;
    private Action closeAction;

    public AbstractDialog(Window window) {
        this(window, "");
    }

    public AbstractDialog(Window window, String title) {
        this(window, title, true);
    }

    public AbstractDialog(Window window, String title, boolean modal) {
        super(window, title, modal ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
        this.init();
    }

    protected Component getInitialFocusedComponent() {
        return null;
    }

    protected JButton getDefaultButton() {
        return null;
    }

    private void init() {
        try {
            this.setBundle(AbstractDialog.class.getName());
        }
        catch (MissingResourceException e) {
            System.err.println("Missing resources for " + AbstractDialog.class.getName());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        this.setResizable(false);
        this.closeOnEscape = true;
        this.updateEscapeBinding();
    }

    public void setCloseOnEsc(boolean b) {
        if (this.closeOnEscape == b) {
            return;
        }
        this.closeOnEscape = b;
        this.updateEscapeBinding();
    }

    public boolean isCloseOnEscape() {
        return this.closeOnEscape;
    }

    private void updateEscapeBinding() {
        this.removeEscapeBinding();
        if (this.isCloseOnEscape()) {
            this.registerEscapeBinding();
        }
    }

    private void removeEscapeBinding() {
        this.getRootPane().getInputMap(2).remove(KeyStroke.getKeyStroke(27, 0));
        this.getRootPane().getActionMap().remove(CLOSE_ACTION_KEY);
    }

    private void registerEscapeBinding() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CLOSE_ACTION_KEY);
        this.getRootPane().getActionMap().put(CLOSE_ACTION_KEY, this.getCancelAction());
    }

    protected void setBundle(String bundle) {
        this.setBundle(ResourceBundle.getBundle(bundle));
    }

    protected void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    protected abstract JComponent buildButtonBar();

    protected abstract JComponent buildContentPanel();

    public boolean canceled() {
        return this.canceled;
    }

    public void doOk() {
        this.apply();
        this.close();
    }

    public void open() {
        this.build();
        this.canceled = false;
        if (this.getInitialFocusedComponent() != null) {
            this.getInitialFocusedComponent().requestFocusInWindow();
        }
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void cancel() {
        this.reset();
        this.canceled = true;
        this.close();
    }

    public void reset() {
    }

    public void apply() {
    }

    protected void handleWindowClosing() {
        this.cancel();
    }

    private void build() {
        this.setContentPane(this.buildPane());
        if (this.getDefaultButton() != null) {
            this.getRootPane().setDefaultButton(this.getDefaultButton());
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JComponent buildPane() {
        JPanel result = new JPanel();
        BorderLayout layout = new BorderLayout();
        layout.setVgap(17);
        result.setLayout(layout);
        result.setBorder(this.getDefaultBorder());
        result.add((Component)this.buildContentPanel(), "Center");
        JComponent buttonBar = this.buildButtonBar();
        if (buttonBar != null) {
            result.add((Component)buttonBar, "South");
        }
        return result;
    }

    protected Border getDefaultBorder() {
        return DEFAULT_BORDER;
    }

    protected JComponent buildCloseButtonBar() {
        return this.buildCloseButtonBar(true);
    }

    protected JComponent buildCloseButtonBar(boolean defaultButton) {
        JButton button = new JButton(this.getCloseAction());
        if (defaultButton) {
            this.getRootPane().setDefaultButton(button);
        }
        return ButtonBarFactory.buildRightAlignedBar((JButton)button);
    }

    protected JComponent buildOKCancelButtonBar() {
        JButton ok = new JButton(this.getOKAction());
        JButton cancel = new JButton(this.getCancelAction());
        this.getRootPane().setDefaultButton(ok);
        return ButtonBarFactory.buildOKCancelBar((JButton)ok, (JButton)cancel);
    }

    protected Action getOKAction() {
        if (this.okAction == null) {
            this.okAction = new OKAction();
        }
        return this.okAction;
    }

    protected Action getApplyAction() {
        if (this.applyAction == null) {
            this.applyAction = new ApplyAction();
        }
        return this.applyAction;
    }

    protected Action getCloseAction() {
        if (this.closeAction == null) {
            this.closeAction = new CloseAction();
        }
        return this.closeAction;
    }

    protected Action getCancelAction() {
        if (this.cancelAction == null) {
            this.cancelAction = new CancelAction();
        }
        return this.cancelAction;
    }

    protected Action getResetAction() {
        if (this.resetAction == null) {
            this.resetAction = new ResetAction();
        }
        return this.resetAction;
    }

    protected final String getString(String id) {
        return this.getString(id, id);
    }

    protected final String getString(String id, String def) {
        if (this.bundle == null) {
            return def;
        }
        return Utils.getString(this.bundle, id, def);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            AbstractDialog.this.handleWindowClosing();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelAction() {
            super(AbstractDialog.this.getString(AbstractDialog.CANCEL_LABEL, AbstractDialog.CANCEL));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDialog.this.cancel();
        }
    }

    private class ResetAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ResetAction() {
            super(AbstractDialog.this.getString(AbstractDialog.RESET_LABEL, AbstractDialog.RESET));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDialog.this.reset();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ApplyAction() {
            super(AbstractDialog.this.getString(AbstractDialog.APPLY_LABEL, AbstractDialog.APPLY));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDialog.this.apply();
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OKAction() {
            super(AbstractDialog.this.getString(AbstractDialog.OK));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDialog.this.doOk();
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseAction() {
            super(AbstractDialog.this.getString(AbstractDialog.CLOSE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDialog.this.close();
        }
    }
}

