/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.swing;

import chemaxon.marvin.uif.util.swing.AbstractDialog;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class ExceptionDialog
extends AbstractDialog {
    private static final String SHOW_DETAILS_TEXT = "Details >>";
    private static final String HIDE_DETAILS_TEXT = "Details <<";
    private JTextArea messageArea;
    private JTextArea detailsArea;
    private JButton okButton;
    private JToggleButton detailsButton;
    private Throwable throwable;
    private JScrollPane scrollPane;

    public ExceptionDialog(Dialog dialog, String title, Throwable t) {
        super((Window)dialog, title);
        this.throwable = t;
    }

    public ExceptionDialog(Frame frame, String title, Throwable t) {
        super((Window)frame, title);
        this.throwable = t;
    }

    public static void showErrorDialog(Window parent, String tittle, Throwable t) {
        if (parent instanceof Frame) {
            new ExceptionDialog((Frame)parent, tittle, t).open();
        } else if (parent instanceof Dialog) {
            new ExceptionDialog((Dialog)parent, tittle, t).open();
        } else {
            new ExceptionDialog((Dialog)null, tittle, t).open();
        }
    }

    public static void showErrorDialog(Dialog parent, String tittle, Throwable t) {
        new ExceptionDialog(parent, tittle, t).open();
    }

    @Override
    protected JComponent buildButtonBar() {
        return null;
    }

    private void initComponents() {
        this.detailsArea = new JTextArea(7, 40);
        this.detailsArea.setEditable(false);
        this.detailsArea.setText(this.parseText());
        this.detailsArea.setOpaque(false);
        this.messageArea = new JTextArea(1, 40);
        this.messageArea.setText(this.throwable.getMessage());
        this.messageArea.setEditable(false);
        this.messageArea.setOpaque(false);
        this.scrollPane = new JScrollPane(this.detailsArea);
        this.scrollPane.setVisible(false);
        this.okButton = new JButton("OK");
        this.detailsButton = new JToggleButton(SHOW_DETAILS_TEXT);
        this.detailsButton.addItemListener(new DetailsHandler());
        this.okButton.addActionListener(new CloseAction());
    }

    private void showDetails() {
        this.scrollPane.setVisible(true);
        this.detailsButton.setText(HIDE_DETAILS_TEXT);
        this.detailsArea.scrollRectToVisible(new Rectangle(0, 0));
        this.pack();
    }

    private void hideDetails() {
        this.scrollPane.setVisible(false);
        this.detailsButton.setText(SHOW_DETAILS_TEXT);
        this.pack();
    }

    private String parseText() {
        StringWriter writer = new StringWriter();
        this.throwable.printStackTrace(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }

    @Override
    protected JComponent buildContentPanel() {
        this.initComponents();
        JPanel result = new JPanel();
        FormLayout layout = new FormLayout("pref, 8dlu, 0:grow, pref, 3dlu, pref", "pref, 8dlu, pref, 3dlu, pref");
        layout.setColumnGroups((int[][])new int[][]{{4, 6}});
        result.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        result.add((Component)new JLabel(UIManager.getIcon("OptionPane.warningIcon")), cc.xy(1, 1));
        result.add((Component)this.messageArea, cc.xyw(3, 1, 4));
        result.add((Component)this.okButton, cc.xy(4, 3));
        result.add((Component)this.detailsButton, cc.xy(6, 3));
        result.add((Component)this.scrollPane, cc.xyw(1, 5, 6));
        return result;
    }

    private final class DetailsHandler
    implements ItemListener {
        private DetailsHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (ExceptionDialog.this.detailsButton.isSelected()) {
                ExceptionDialog.this.showDetails();
            } else {
                ExceptionDialog.this.hideDetails();
            }
        }
    }

    private final class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExceptionDialog.this.close();
        }
    }
}

