/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.swing;

import chemaxon.marvin.uif.util.swing.ArrowIcon;
import chemaxon.marvin.uif.util.swing.SeparatorHandlerLayout;
import chemaxon.marvin.uif.util.swing.ToolBarLayout;
import chemaxon.marvin.uif.util.swing.WindowGrabber;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class ExtendedToolBar
extends JToolBar {
    protected static final Object PLACEHOLDER_KEY = new Object();
    protected ToolBarLayout layout;

    public ExtendedToolBar() {
        this(0);
    }

    public ExtendedToolBar(int orientation) {
        this(null, orientation);
    }

    public ExtendedToolBar(String name, int orientation) {
        super(name, orientation);
        this.layout = new ToolBarLayout(this, null, orientation);
        DefaultArrowButton arrowButton = new DefaultArrowButton();
        this.layout.setMoreButton(arrowButton);
        super.setLayout(SeparatorHandlerLayout.createWrapper(this, this.layout));
    }

    public JComponent getMoreComponent() {
        return this.layout.getMoreButton();
    }

    public void setMoreComponent(JButton button) {
        JComponent more = this.getMoreComponent();
        if (more != null) {
            this.remove(more);
        }
        this.add(button);
        this.layout.setMoreButton(button);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public ExtendedToolBar(String name) {
        this(name, 0);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (this.layout.getMoreButton() != null) {
            this.add(this.layout.getMoreButton());
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (this.layout.getMoreButton() != null) {
            super.addImpl(this.layout.getMoreButton(), null, this.getComponentCount() - 1);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getMoreComponent().setEnabled(enabled);
    }

    static Point adjustPopupLocationToFitScreen(Component container, Component invoker, int xposition, int yposition) {
        Rectangle screenBounds;
        Insets screenInsets;
        Point p = new Point(xposition, yposition);
        if (GraphicsEnvironment.isHeadless()) {
            return p;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(p)) continue;
            gc = dgc;
            break;
        }
        if (gc == null && invoker != null) {
            gc = invoker.getGraphicsConfiguration();
        }
        if (gc != null) {
            screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
        } else {
            screenInsets = new Insets(0, 0, 0, 0);
            screenBounds = new Rectangle(toolkit.getScreenSize());
        }
        int scrWidth = screenBounds.width - Math.abs(screenInsets.left + screenInsets.right);
        int scrHeight = screenBounds.height - Math.abs(screenInsets.top + screenInsets.bottom);
        Dimension size = container.getPreferredSize();
        long pw = (long)p.x + (long)size.width;
        long ph = (long)p.y + (long)size.height;
        if (pw > (long)(screenBounds.x + scrWidth)) {
            p.x = screenBounds.x + scrWidth - size.width;
        }
        if (ph > (long)(screenBounds.y + scrHeight)) {
            p.y = screenBounds.y + scrHeight - size.height;
        }
        if (p.x < screenBounds.x) {
            p.x = screenBounds.x;
        }
        if (p.y < screenBounds.y) {
            p.y = screenBounds.y;
        }
        return p;
    }

    private static class PopupHandler
    extends WindowGrabber {
        private PopupAction action;

        public PopupHandler(PopupAction action, Window target, Container popup) {
            super(target, popup);
            this.action = action;
        }

        @Override
        protected void cancelPopup() {
            this.action.cancelPopup();
        }
    }

    private class PopupAction
    implements ActionListener {
        private Popup popup;
        private JComponent container;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.popup != null) {
                return;
            }
            this.container = this.createContainer();
            if (this.container.getComponentCount() == 0) {
                return;
            }
            this.showPopup();
        }

        private JComponent createContainer() {
            List<Component> items = null;
            items = this.getInvisibleComponents();
            ExtendedToolBar.this.layout.setMoreAlwaysVisible(true);
            JToolBar result = new JToolBar();
            result.setFloatable(false);
            result.setLayout(SeparatorHandlerLayout.createWrapper(result, new BoxLayout(result, 0)));
            this.addItems(items, result);
            return result;
        }

        private void addItems(List<Component> items, JComponent result) {
            for (Component component : items) {
                this.replace((JComponent)component);
                result.add(component);
            }
            ExtendedToolBar.this.invalidate();
            ExtendedToolBar.this.repaint();
        }

        private List<Component> getInvisibleComponents() {
            Component[] comps;
            ArrayList<Component> items = new ArrayList<Component>(3);
            for (Component component : comps = ExtendedToolBar.this.getComponents()) {
                if (!component.isVisible() || component.getWidth() != 0 || component.getHeight() != 0 || component == ExtendedToolBar.this.getMoreComponent()) continue;
                items.add(component);
            }
            return items;
        }

        private void replace(JComponent component) {
            int i = ExtendedToolBar.this.getComponentIndex(component);
            Box.Filler placeHolder = new Box.Filler(component.getMinimumSize(), component.getPreferredSize(), component.getMaximumSize());
            placeHolder.putClientProperty(PLACEHOLDER_KEY, Boolean.TRUE);
            placeHolder.setBorder(component.getBorder());
            placeHolder.setAlignmentX(component.getAlignmentX());
            placeHolder.setAlignmentY(component.getAlignmentY());
            ExtendedToolBar.this.remove(component);
            ExtendedToolBar.this.add((Component)placeHolder, i);
        }

        private void showPopup() {
            Point pos = ExtendedToolBar.this.getMoreComponent().getLocationOnScreen();
            if (ExtendedToolBar.this.getOrientation() == 0) {
                pos.translate(0, ExtendedToolBar.this.getMoreComponent().getHeight());
            } else {
                pos.translate(ExtendedToolBar.this.getMoreComponent().getWidth(), 0);
            }
            pos = ExtendedToolBar.adjustPopupLocationToFitScreen(this.container, ExtendedToolBar.this.getMoreComponent(), pos.x, pos.y);
            this.popup = PopupFactory.getSharedInstance().getPopup(ExtendedToolBar.this, this.container, pos.x, pos.y);
            this.popup.show();
            new PopupHandler(this, SwingUtilities.getWindowAncestor(ExtendedToolBar.this.getMoreComponent()), this.container);
        }

        void cancelPopup() {
            if (this.popup != null) {
                ExtendedToolBar.this.layout.setMoreAlwaysVisible(false);
                this.popup.hide();
                this.empty();
                this.popup = null;
            }
        }

        private void empty() {
            for (int i = ExtendedToolBar.this.getComponentCount() - 1; i >= 0; --i) {
                JComponent component;
                if (!(ExtendedToolBar.this.getComponent(i) instanceof JComponent) || (component = (JComponent)ExtendedToolBar.this.getComponent(i)).getClientProperty(PLACEHOLDER_KEY) == null) continue;
                ExtendedToolBar.this.remove(i);
            }
            Component[] components = this.container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                ExtendedToolBar.this.add(components[i]);
            }
            ExtendedToolBar.this.revalidate();
            ExtendedToolBar.this.repaint();
        }
    }

    private class DefaultArrowButton
    extends JButton
    implements PropertyChangeListener {
        public DefaultArrowButton() {
            this.updateIcon();
            this.setFocusable(false);
            ExtendedToolBar.this.addPropertyChangeListener(this);
            this.addActionListener(new PopupAction());
        }

        private void updateIcon() {
            this.setIcon(this.createIcon());
        }

        private Icon createIcon() {
            return new ArrowIcon(ExtendedToolBar.this.getOrientation());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("orientation")) {
                this.updateIcon();
            }
        }
    }
}

