/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.UIResource;

public class SeparatorHandlerLayout
implements PropertyChangeListener {
    private SeparatorHandlerLayout() {
    }

    public static LayoutManager createWrapper(Container container, LayoutManager delegate) {
        return SeparatorHandlerLayout.createWrapperImpl(container, delegate);
    }

    public static void install(JComponent component) {
        if (component.getLayout() instanceof Wrapper) {
            System.err.println("Component layout is a Wrapper instance!");
        }
        SeparatorHandlerLayout handler = new SeparatorHandlerLayout();
        SeparatorHandlerLayout.updateLayoutManager(component);
        component.addPropertyChangeListener("UI", handler);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof Container)) {
            return;
        }
        SeparatorHandlerLayout.updateLayoutManager((Container)evt.getSource());
    }

    private static void updateLayoutManager(Container component) {
        if (component.getLayout() == null) {
            return;
        }
        if (component.getLayout() instanceof Wrapper) {
            return;
        }
        component.setLayout(SeparatorHandlerLayout.createWrapperImpl(component, component.getLayout()));
    }

    private static LayoutManager createWrapperImpl(Container container, LayoutManager layout) {
        if (layout == null) {
            return null;
        }
        if (layout instanceof LayoutManager2) {
            return layout instanceof UIResource ? new UIWrapper2((LayoutManager2)layout) : new Wrapper2((LayoutManager2)layout);
        }
        return layout instanceof UIResource ? new UIWrapper(container, layout) : new Wrapper(container, layout);
    }

    private static final class UIWrapper2
    extends Wrapper2
    implements UIResource {
        public UIWrapper2(LayoutManager2 delegate) {
            super(delegate);
        }
    }

    private static final class UIWrapper
    extends Wrapper
    implements UIResource {
        public UIWrapper(Container container, LayoutManager delegate) {
            super(container, delegate);
        }
    }

    private static class Wrapper2
    extends AbstractWrapper
    implements LayoutManager2 {
        public Wrapper2(LayoutManager2 delegate) {
            super(delegate);
        }

        private LayoutManager2 getDelegate2() {
            return (LayoutManager2)this.getDelegate();
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.getDelegate2().addLayoutComponent(comp, constraints);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.getDelegate2().maximumLayoutSize(target);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return this.getDelegate2().getLayoutAlignmentX(target);
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return this.getDelegate2().getLayoutAlignmentY(target);
        }

        @Override
        public void invalidateLayout(Container target) {
            this.markDirty();
            this.getDelegate2().invalidateLayout(target);
        }
    }

    private static class Wrapper
    extends AbstractWrapper
    implements ContainerListener,
    ComponentListener {
        public Wrapper(Container container, LayoutManager delegate) {
            super(delegate);
            container.addContainerListener(this);
            for (Component component : container.getComponents()) {
                component.addComponentListener(this);
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (this.check(e.getContainer())) {
                e.getChild().addComponentListener(this);
            }
        }

        private boolean check(Component component) {
            if (component.getParent() != null && component.getParent().getLayout() != this) {
                component.removeComponentListener(this);
                return false;
            }
            return true;
        }

        private boolean check(Container container) {
            if (container == null) {
                return false;
            }
            if (container.getLayout() != this) {
                container.removeContainerListener(this);
                return false;
            }
            return true;
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            e.getChild().removeComponentListener(this);
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (this.check(e.getComponent())) {
                this.markDirty();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (this.check(e.getComponent())) {
                this.markDirty();
            }
        }
    }

    private static abstract class AbstractWrapper
    implements LayoutManager {
        private final LayoutManager delegate;
        private boolean dirty = true;
        private boolean updating;

        public AbstractWrapper(LayoutManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.delegate.addLayoutComponent(name, comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.delegate.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.updateContents(parent);
            return this.delegate.preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            this.updateContents(parent);
            return this.delegate.minimumLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.updateContents(parent);
            this.delegate.layoutContainer(parent);
        }

        protected final void markDirty() {
            if (!this.updating) {
                this.dirty = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateContents(Container container) {
            if (!this.dirty) {
                return;
            }
            this.updating = true;
            try {
                int i;
                boolean[] b = new boolean[container.getComponentCount()];
                int lastSeparator = -1;
                boolean hasComponent = false;
                for (i = 0; i < container.getComponentCount(); ++i) {
                    Component component = container.getComponent(i);
                    b[i] = component.isVisible();
                    if (component instanceof JSeparator) {
                        if (hasComponent && lastSeparator == -1) {
                            lastSeparator = i;
                            continue;
                        }
                        b[i] = false;
                        continue;
                    }
                    if (!component.isVisible()) continue;
                    if (lastSeparator != -1) {
                        b[lastSeparator] = hasComponent;
                        lastSeparator = -1;
                    }
                    hasComponent = true;
                }
                if (lastSeparator != -1) {
                    b[lastSeparator] = false;
                }
                for (i = 0; i < b.length; ++i) {
                    if (b[i] == container.getComponent(i).isVisible()) continue;
                    container.getComponent(i).setVisible(b[i]);
                }
            }
            finally {
                this.updating = false;
                this.dirty = false;
            }
        }

        protected LayoutManager getDelegate() {
            return this.delegate;
        }
    }
}

