/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.util.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

abstract class WindowGrabber
extends WindowAdapter
implements ComponentListener,
AWTEventListener,
MouseListener,
MouseWheelListener,
MouseMotionListener {
    private Window target;
    private JRootPane popupWindow;
    private List components;
    private boolean globalListener;

    public WindowGrabber(Window target, Container popup) {
        this.target = target;
        this.components = new ArrayList(3);
        this.popupWindow = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, popup);
        this.grabWindow();
    }

    public void grabWindow() {
        this.ungrabWindow();
        this.target.addWindowListener(this);
        this.target.addComponentListener(this);
        this.target.addWindowFocusListener(this);
        this.target.addMouseListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 131184L);
            this.globalListener = true;
        }
        catch (SecurityException e) {
            this.globalListener = false;
            this.installMouseListeners(this.target);
        }
    }

    public void ungrabWindow() {
        this.target.removeWindowListener(this);
        this.target.removeComponentListener(this);
        this.target.removeWindowFocusListener(this);
        this.target.removeMouseListener(this);
        if (this.globalListener) {
            try {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
            catch (SecurityException securityException) {}
        } else {
            this.removeMouseListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installMouseListeners(Container c) {
        Component ignore = null;
        if (c == this.popupWindow) {
            return;
        }
        if (c instanceof JRootPane && ((ignore = ((JRootPane)c).getGlassPane()).getMouseListeners().length > 0 || ignore.getMouseMotionListeners().length > 0 || ignore.getMouseWheelListeners().length > 0)) {
            ignore = null;
        }
        Object object = c.getTreeLock();
        synchronized (object) {
            int ncomponents = c.getComponentCount();
            Component[] component = c.getComponents();
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = component[i];
                if (!comp.isVisible()) continue;
                if (comp != ignore) {
                    comp.addMouseListener(this);
                    comp.addMouseMotionListener(this);
                    comp.addMouseWheelListener(this);
                    this.components.add(comp);
                }
                if (!(comp instanceof Container)) continue;
                Container cont = (Container)comp;
                this.installMouseListeners(cont);
            }
        }
    }

    private void removeMouseListeners() {
        if (this.components.isEmpty()) {
            return;
        }
        for (Component component : this.components) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            component.removeMouseWheelListener(this);
        }
        this.components.clear();
        this.components = new ArrayList();
    }

    protected abstract void cancelPopup();

    private void handleStateChange() {
        this.ungrabWindow();
        this.cancelPopup();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.handleStateChange();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.handleStateChange();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.handleStateChange();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.handleStateChange();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.handleStateChange();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.handleStateChange();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.handleStateChange();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    private void handleMouseEvent(MouseEvent e) {
        if (e.getComponent() != this.popupWindow) {
            this.handleStateChange();
        }
    }

    @Override
    public void eventDispatched(AWTEvent ev) {
        switch (ev.getID()) {
            case 501: 
            case 502: 
            case 506: 
            case 507: {
                Component src = (Component)ev.getSource();
                if (this.isInPopup(src)) {
                    return;
                }
                this.handleStateChange();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.handleMouseEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private boolean isInPopup(Component c) {
        Component p;
        if (c == null || (p = c.getParent()) == null) {
            return false;
        }
        while (p != null) {
            if (p == this.popupWindow) {
                return true;
            }
            if (p instanceof JPopupMenu) {
                p = ((JPopupMenu)p).getInvoker();
                continue;
            }
            p = p.getParent();
        }
        return false;
    }
}

