/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.util.MolLoader;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class AbbrevGroupCollection {
    private String[] abbrevNames;
    private String[] fileContents;
    private Molecule[] molecules;
    private int size;
    private int cleanDim = 0;
    private String cleanOpts = null;

    public AbbrevGroupCollection() {
        this.abbrevNames = new String[0];
        this.fileContents = new String[0];
        this.molecules = new Molecule[0];
        this.size = 0;
    }

    public AbbrevGroupCollection(String text) {
        String[] line;
        Vector<String> abbrevNamesV = new Vector<String>();
        Vector<String> fileContentsV = new Vector<String>();
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        LineNumberReader lr = new LineNumberReader(new StringReader(text));
        do {
            int abbrevIdx;
            if ((line = AbbrevGroupCollection.readLine(lr)) == null || line[0] == null) continue;
            Integer idx = (Integer)nameMap.get(line[0]);
            int n = abbrevIdx = idx != null ? idx : -1;
            if (abbrevIdx < 0) {
                nameMap.put(line[0], abbrevNamesV.size());
                abbrevNamesV.add(line[0]);
                fileContentsV.add(line[1]);
                AbbrevGroupCollection.addAlternativeName(line[1], abbrevNamesV, fileContentsV, nameMap);
                continue;
            }
            fileContentsV.setElementAt(line[1], abbrevIdx);
        } while (line != null);
        int n = abbrevNamesV.size();
        this.abbrevNames = new String[n];
        this.fileContents = new String[n];
        this.molecules = new Molecule[n];
        abbrevNamesV.copyInto(this.abbrevNames);
        fileContentsV.copyInto(this.fileContents);
        this.size = n;
    }

    public void setClean(int cleanDim, String cleanOpts) {
        this.cleanDim = cleanDim;
        this.cleanOpts = cleanOpts;
    }

    private static void addAlternativeName(String s, Vector<String> anV, Vector<String> fcV, Map<String, Integer> nameMap) {
        String lcs = s.toLowerCase();
        if (lcs.indexOf("rightname=") > 0 || lcs.indexOf("leftname=") > 0) {
            String an = s.substring(lcs.indexOf("name=") + 5);
            StringTokenizer st = new StringTokenizer(an, "\t ");
            an = st.nextToken();
            nameMap.put(an, anV.size());
            anV.add(an);
            fcV.add(s);
        }
    }

    public AbbrevGroupCollection(Molecule[] mols) {
        this();
        for (int i = 0; i < mols.length; ++i) {
            if (mols[i] == null) continue;
            this.add(mols[i]);
        }
    }

    public int getSize() {
        return this.size;
    }

    public String getAbbrevName(int i) {
        return this.abbrevNames[i];
    }

    public String getString(int i) {
        return this.fileContents[i];
    }

    public Molecule getMolecule(String name) throws MRecordParseException, MolFormatException, IOException {
        for (int i = 0; i < this.abbrevNames.length; ++i) {
            if (!this.abbrevNames[i].equals(name)) continue;
            return this.getMolecule(i);
        }
        return null;
    }

    public Molecule getMolecule(int i) throws MRecordParseException, MolFormatException, IOException {
        String text = this.fileContents[i];
        Molecule m = this.molecules[i];
        if (m == null && text != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
            MolInputStream mis = new MolInputStream((InputStream)is, "abbrevgroup");
            MRecordImporter mri = MolLoader.createImporter(mis, null);
            Molecule mm = mri.readMol(null);
            if (mm != null && this.cleanDim != 0) {
                mm.clean(this.cleanDim, this.cleanOpts);
            }
            this.molecules[i] = m = mm;
        }
        return m != null ? m.cloneMolecule() : null;
    }

    public String[] getAbbrevNames() {
        String[] tmp = new String[this.size];
        System.arraycopy(this.abbrevNames, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public String[] getAbbrevNamesLC() {
        String[] tmp = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            tmp[i] = this.abbrevNames[i].toLowerCase();
        }
        return tmp;
    }

    public void add(AbbrevGroupCollection other) {
        int dsize = other.getSize();
        int n = this.size + dsize;
        if (n > this.abbrevNames.length) {
            this.increaseArrayCapacities(n);
        }
        System.arraycopy(other.abbrevNames, 0, this.abbrevNames, this.size, dsize);
        System.arraycopy(other.fileContents, 0, this.fileContents, this.size, dsize);
        System.arraycopy(other.molecules, 0, this.molecules, this.size, dsize);
        this.size = n;
    }

    private void increaseArrayCapacities(int newSize) {
        String[] tmps = new String[newSize];
        System.arraycopy(this.abbrevNames, 0, tmps, 0, this.size);
        this.abbrevNames = tmps;
        tmps = new String[newSize];
        System.arraycopy(this.fileContents, 0, tmps, 0, this.size);
        this.fileContents = tmps;
        Molecule[] tmpmols = new Molecule[newSize];
        System.arraycopy(this.molecules, 0, tmpmols, 0, this.size);
        this.molecules = tmpmols;
    }

    private void add(Molecule m) {
        int n = m.getSgroupCount();
        if (n != 0) {
            m = m.cloneMolecule();
        } else if (m.getProperty("abbreviation") != null) {
            this.addAbbreviation(m.getProperty("abbreviation"), m);
        }
        for (int i = 0; i < n; ++i) {
            Sgroup sg = m.getSgroup(i);
            String s = sg.getSubscript();
            this.addAbbreviation(s, sg.createMolecule());
        }
    }

    private void addAbbreviation(String s, Molecule m) {
        int j;
        boolean found = false;
        for (j = 0; j < this.size && !found; ++j) {
            if (!this.abbrevNames[j].equalsIgnoreCase(s)) continue;
            found = true;
        }
        if (!found) {
            j = this.size;
            this.addAbbrevGroup();
            this.abbrevNames[j] = s;
            this.fileContents[j] = null;
            this.molecules[j] = m;
        }
    }

    private void addAbbrevGroup() {
        if (this.size == 0 && this.abbrevNames.length == 0) {
            int n = 8;
            this.abbrevNames = new String[n];
            this.fileContents = new String[n];
            this.molecules = new Molecule[n];
        } else if (this.size == this.abbrevNames.length) {
            this.increaseArrayCapacities((this.size + 1) * 3 / 2);
        }
        ++this.size;
    }

    private static String[] readLine(LineNumberReader r) {
        try {
            String line = r.readLine();
            if (line != null && line.length() > 0) {
                StringTokenizer st = new StringTokenizer(line, "\t");
                if (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    return new String[]{s, line};
                }
                return new String[]{null, line};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

