/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DistantColorCreator {
    private int targetColorCount = 0;
    private List<Color> result = null;
    private Collection<Color> excludedColors = null;

    public List<Color> generateColors(int count, Collection<Color> forbiddenColors) {
        HashSet hashSet = this.excludedColors = forbiddenColors == null ? new HashSet() : forbiddenColors;
        if (count + this.excludedColors.size() >= 0x1000000) {
            throw new IllegalArgumentException("Too many required and forbidden colors.");
        }
        if (count < 1) {
            throw new IllegalArgumentException("The number of required colors must be at least one.");
        }
        this.targetColorCount = count;
        boolean solved = false;
        int distance = 64;
        while (!solved) {
            this.result = new ArrayList<Color>();
            try {
                this.generateColors(distance);
                solved = true;
            }
            catch (TooLargeMinimalDifferenceException e) {
                distance /= 2;
            }
        }
        return this.result;
    }

    private boolean isDone() {
        return this.result.size() >= this.targetColorCount;
    }

    private boolean addIfPossible(int red, int green, int blue, int distance) {
        if (this.isDone()) {
            return true;
        }
        for (Color color : this.excludedColors) {
            if (Math.abs(red - color.getRed()) + Math.abs(green - color.getGreen()) + Math.abs(blue - color.getBlue()) >= 3 * distance) continue;
            return false;
        }
        this.result.add(new Color(red, green, blue));
        return this.isDone();
    }

    private void generateInnerColors(int step, int distance) throws TooLargeMinimalDifferenceException {
        if (step >= 9) {
            throw new TooLargeMinimalDifferenceException();
        }
        int start = 256 >> step;
        int stepSize = 256 >> step - 1;
        int stepCount = 1 << step - 1;
        int blue = start;
        for (int blueIndex = 0; blueIndex < stepCount; ++blueIndex) {
            int red = start;
            for (int redIndex = 0; redIndex < stepCount; ++redIndex) {
                int green = start;
                for (int greenIndex = 0; greenIndex < stepCount; ++greenIndex) {
                    if (this.addIfPossible(red, green, blue, distance)) {
                        return;
                    }
                    green += stepSize;
                }
                red += stepSize;
            }
            blue += stepSize;
        }
        this.generateInnerColors(step + 1, distance);
    }

    private void generateColors(int distance) throws TooLargeMinimalDifferenceException {
        if (this.addIfPossible(255, 0, 0, distance)) {
            return;
        }
        if (this.addIfPossible(0, 255, 0, distance)) {
            return;
        }
        if (this.addIfPossible(0, 0, 255, distance)) {
            return;
        }
        if (this.addIfPossible(255, 255, 0, distance)) {
            return;
        }
        if (this.addIfPossible(255, 0, 255, distance)) {
            return;
        }
        if (this.addIfPossible(0, 255, 255, distance)) {
            return;
        }
        if (this.addIfPossible(0, 0, 0, distance)) {
            return;
        }
        if (this.addIfPossible(255, 255, 255, distance)) {
            return;
        }
        this.generateInnerColors(1, distance);
    }

    private class TooLargeMinimalDifferenceException
    extends Exception {
        private TooLargeMinimalDifferenceException() {
        }
    }
}

