/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.modules.win.ole.MarvinOleServer;
import chemaxon.util.FindCodeBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class Environment
extends BasicEnvironment {
    private static int isMarvinInJar = -1;
    private static boolean isSkinEnabled = false;
    private static boolean useDefaultDatatransferConfig = false;

    public static synchronized boolean isAdmin() {
        boolean b = false;
        if (!UNTRUSTED) {
            try {
                File dir = null;
                if (MSWINDOWS) {
                    String jlibpath = System.getProperty("java.library.path");
                    StringTokenizer st = new StringTokenizer(jlibpath, System.getProperty("path.separator"));
                    while (st.hasMoreTokens()) {
                        String s = st.nextToken();
                        String lws = s.toLowerCase();
                        if (!lws.endsWith("\\system32") && !lws.endsWith("\\system32\\")) continue;
                        dir = new File(s);
                        break;
                    }
                }
                if (dir == null) {
                    dir = new File(System.getProperty("java.home"));
                }
                if (dir.exists() && dir.isDirectory()) {
                    File f = new File(dir, ".chemaxon-writecheck.tmp");
                    FileOutputStream fout = new FileOutputStream(f);
                    fout.write(0);
                    fout.close();
                    f.delete();
                    b = true;
                }
            }
            catch (IOException ioex) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return b;
    }

    public static synchronized void setSkinEnabled(boolean b) {
        isSkinEnabled = b;
    }

    public static boolean isSkinEnabled() {
        return isSkinEnabled;
    }

    public static boolean installPlasticLookAndFeel(boolean set) {
        try {
            Class<?> plfClass = Class.forName("com.jgoodies.looks.plastic.PlasticLookAndFeel");
            Class<?> themeClass = Class.forName("com.jgoodies.looks.plastic.PlasticTheme");
            Method setThemeMethod = plfClass.getMethod("setPlasticTheme", themeClass);
            Class<?> skyBluerClass = Class.forName("com.jgoodies.looks.plastic.theme.SkyBluer");
            Object skyBluer = skyBluerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            setThemeMethod.invoke(null, skyBluer);
            UIManager.installLookAndFeel("JGoodies Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            if (set) {
                Class<?> plfXPClass = Class.forName("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                LookAndFeel plf = (LookAndFeel)plfXPClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                UIManager.setLookAndFeel(plf);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static URL getCodeBase() {
        return codeBase;
    }

    public static synchronized void setCodeBase(URL url) {
        codeBase = url;
        try {
            System.setProperty("chemaxon.marvin.util.codeBase", url.toString());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Deprecated
    public static boolean isDesktopApplication() {
        return false;
    }

    @Deprecated
    public static void registerAsDesktopApplication() {
    }

    public static boolean isMSpaceEnabled() {
        boolean enabled = false;
        if (!UNTRUSTED && JAVA15_COMPATIBLE) {
            enabled = true;
            if (Environment.getCodeBase() == null) {
                try {
                    Class.forName("chemaxon.marvin.space.MSpaceInstaller");
                }
                catch (Exception e) {
                    enabled = false;
                }
            }
        }
        return enabled;
    }

    public static InputStream getResourceAsStream(Class<?> cl, String filename) {
        return BasicEnvironment.getResourceAsStream(cl, filename);
    }

    public static InputStream getResourceAsStream(Class<?> cl, String filename, boolean ignoreCache) {
        return BasicEnvironment.getResourceAsStream(cl, filename, ignoreCache);
    }

    public static URL getLocalURL(Class<?> cl, String filename) {
        String s = filename;
        if (!s.startsWith("/")) {
            s = "/".concat(s);
        }
        URL url = null;
        try {
            url = FindCodeBase.getResource(cl, filename);
        }
        catch (SecurityException sex) {
            sex.printStackTrace();
        }
        return url;
    }

    public static synchronized void printMem() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        StringBuffer sb = new StringBuffer("Memory: ");
        DecimalFormat fmt = new DecimalFormat("0.0");
        sb.append(fmt.format((double)total / 1048576.0));
        sb.append("MB total\t");
        sb.append(fmt.format((double)(total - free) / 1048576.0));
        sb.append("MB used");
        System.err.println(sb.toString());
    }

    public static void downloadURL(URL url, File localfile) throws IOException {
        int size;
        int buff_size = 1000;
        BufferedInputStream is = new BufferedInputStream(url.openStream());
        File parentDir = localfile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(localfile));
        byte[] buff = new byte[buff_size];
        while ((size = is.read(buff, 0, buff_size)) != -1) {
            os.write(buff, 0, size);
        }
        os.flush();
        is.close();
        os.close();
    }

    public static boolean isOLECopyPlatform() {
        return MSWINDOWS && !UNTRUSTED;
    }

    public static boolean isOLESupported() {
        return Environment.isOLECopyPlatform() && MarvinOleServer.getMarvinDocClsid() != null;
    }

    public static boolean isOLEServerPlatform() {
        return MSWINDOWS && !UNTRUSTED && !APPLET && Environment.isMarvinInJar();
    }

    public static boolean isMarvinInJar() {
        if (isMarvinInJar == -1) {
            URL u = Environment.class.getResource("/chemaxon/marvin/util/Environment.class");
            isMarvinInJar = u != null && u.getProtocol().equals("jar") ? 1 : 0;
        }
        return isMarvinInJar == 1;
    }

    @Deprecated
    public static void inputFileAddedAtStart() {
    }

    @Deprecated
    public static boolean savedFileChooserCwdUseableAtFirstTime() {
        return false;
    }

    public static int getProcessorCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static boolean hasMultipleProcessors() {
        return Environment.getProcessorCount() > 1;
    }

    public static void setSafariOnMac(boolean b) {
        safariOnMac = b;
    }

    public static void setUseDefaultDatatransferConfig(boolean isdefault) {
        if (!APPLET) {
            return;
        }
        useDefaultDatatransferConfig = isdefault;
    }

    public static boolean isUseDefaultDatatransferConfig() {
        if (!APPLET) {
            return false;
        }
        return useDefaultDatatransferConfig;
    }
}

