/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ImageCompare {
    public static void main(String[] args) {
        if (args.length < 2 || args[0].equals("--help")) {
            System.out.println("Bad arguments, 2 image file name is required with full path.");
        }
        File i1 = new File(args[0]);
        File i2 = new File(args[1]);
        if (!i1.exists()) {
            System.out.println("First image file does not exist: " + i1.getPath());
        }
        if (!i2.exists()) {
            System.out.println("Second image file does not exist: " + i2.getPath());
        }
        try {
            ImageCompare.compareAndMaskWithDifference(i1, i2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean compareAndSaveDifference(File i1, File i2, String diffFileName, String ext) throws Exception {
        BufferedImage diffImage = ImageCompare.compare(i1, i2);
        if (diffImage != null) {
            boolean nameFound = false;
            int i = 1;
            while (!nameFound) {
                File df = new File(diffFileName + i + ext);
                if (!df.exists()) {
                    nameFound = true;
                    ImageIO.write((RenderedImage)diffImage, "png", df);
                    System.out.println("Image file showing differences is saved as " + df.getPath());
                }
                ++i;
            }
        }
        return diffImage == null;
    }

    public static boolean compareAndSaveDifference(File i1, File i2) throws Exception {
        String dfName = i1.getParent() + System.getProperty("file.separator") + "diff";
        String ext = i1.getPath().substring(i1.getPath().lastIndexOf("."));
        return ImageCompare.compareAndSaveDifference(i1, i2, dfName, ext);
    }

    public static boolean compareAndMaskWithDifference(File i1, File i2, String maskFileName, String ext) throws Exception {
        BufferedImage diffImage = ImageCompare.compare(i1, i2);
        if (diffImage == null) {
            return true;
        }
        BufferedImage maskedImage = ImageCompare.maskFile(i1, diffImage);
        boolean nameFound = false;
        int i = 1;
        while (!nameFound) {
            File df = new File(maskFileName + i + ext);
            if (!df.exists()) {
                nameFound = true;
                ImageIO.write((RenderedImage)maskedImage, "png", df);
                System.out.println("Image file showing differences is saved as " + df.getPath());
            }
            ++i;
        }
        return false;
    }

    public static boolean compareAndMaskWithDifference(File i1, File i2) throws Exception {
        String dfName = i1.getParent() + System.getProperty("file.separator") + "mask";
        String ext = i1.getPath().substring(i1.getPath().lastIndexOf("."));
        return ImageCompare.compareAndMaskWithDifference(i1, i2, dfName, ext);
    }

    public static BufferedImage compare(File i1, File i2) throws Exception {
        BufferedImage image1 = ImageIO.read(i1);
        BufferedImage image2 = ImageIO.read(i2);
        if (image1 == null || image2 == null) {
            System.out.println("Image read failed, unrecognized image format.");
        }
        return ImageCompare.compare(image1, image2);
    }

    public static BufferedImage compare(BufferedImage image1, BufferedImage image2) {
        int w = image1.getWidth();
        int h = image1.getHeight();
        if (w != image2.getWidth() || h != image2.getHeight()) {
            System.out.println("Warning: Images are not the same size.");
        }
        System.out.print("Comparing images...");
        int[] rawData1 = new int[w * h];
        image1.getRGB(0, 0, w, h, rawData1, 0, w);
        int[] rawData2 = new int[w * h];
        image2.getRGB(0, 0, w, h, rawData2, 0, w);
        int difference = 0;
        for (int i = 0; i < w * h; ++i) {
            if (rawData1[i] == rawData2[i]) continue;
            ++difference;
        }
        System.out.println("done.");
        if (difference == 0) {
            System.out.println("Images are completely the same.");
            return null;
        }
        System.out.println("Difference: " + (double)difference / ((double)(w * h) * 0.01) + "%");
        System.out.print("Writing difference to image file...");
        int[] rawData = new int[w * h];
        for (int i = 0; i < w * h; ++i) {
            rawData[i] = rawData1[i] != rawData2[i] ? -1 : -16777216;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        image.setRGB(0, 0, w, h, rawData, 0, w);
        System.out.println("done.");
        return image;
    }

    public static BufferedImage maskFile(File f, BufferedImage mask) throws Exception {
        BufferedImage image = ImageIO.read(f);
        if (image == null) {
            System.out.println("Image read failed, unrecognized image format.");
        }
        return ImageCompare.maskFile(image, mask);
    }

    public static BufferedImage maskFile(BufferedImage image, BufferedImage mask) {
        int w = image.getWidth();
        int h = image.getHeight();
        System.out.print("Masking image...");
        int[] rawData = new int[w * h];
        image.getRGB(0, 0, w, h, rawData, 0, w);
        int[] rawDataMask = new int[w * h];
        mask.getRGB(0, 0, w, h, rawDataMask, 0, w);
        int[] rawDataMasked = new int[w * h];
        for (int i = 0; i < w * h; ++i) {
            rawDataMasked[i] = rawDataMask[i] == -1 ? rawData[i] : -16777216;
        }
        BufferedImage maskedImage = new BufferedImage(w, h, 2);
        maskedImage.setRGB(0, 0, w, h, rawDataMasked, 0, w);
        System.out.println("done.");
        return maskedImage;
    }
}

