/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class InstallFromJar {
    private static boolean DEBUG = false;

    public static void extractJar(File jarf, File todir) throws IOException {
        InstallFromJar.extractFromJar(jarf, "*", todir);
    }

    public static void extractFromJar(File jarf, String queryentry, File todir) throws IOException {
        if (!jarf.exists()) {
            throw new IOException(jarf.getAbsolutePath() + " is not found.");
        }
        JarFile jarfile = new JarFile(jarf.getAbsolutePath());
        InstallFromJar.report(jarfile.getName());
        Enumeration<JarEntry> e = jarfile.entries();
        while (e.hasMoreElements()) {
            String name;
            JarEntry je = e.nextElement();
            if (je.isDirectory() || !(name = je.getName()).equals(queryentry) && (!queryentry.equals("*") || name.startsWith("META-INF/"))) continue;
            byte[] buf = new byte[8192];
            InstallFromJar.installFile(todir, jarfile, name, buf);
        }
    }

    private static void installFile(File installDir, JarFile jar, String fileName, byte[] buf) throws IOException {
        String outputPath;
        JarEntry entry = jar.getJarEntry(fileName);
        if (entry == null) {
            throw new IOException(jar.getName() + "does not include " + fileName);
        }
        InputStream is = jar.getInputStream(entry);
        BufferedOutputStream out = null;
        File outputFile = new File(installDir, fileName);
        if (outputFile.getParent() != null) {
            outputFile.getParentFile().mkdirs();
        }
        try {
            out = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (Exception e) {
            throw new IOException("Cannot open " + fileName + " for writing");
        }
        try {
            int len;
            while ((len = is.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw new IOException("Cannot write " + fileName + " to local machine");
        }
        try {
            outputPath = outputFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            outputPath = outputFile.getAbsolutePath();
        }
        InstallFromJar.report("Save " + fileName + " from " + jar.getName() + " as " + outputPath);
    }

    private static void report(String msg) {
        if (DEBUG) {
            System.err.println(msg);
        }
    }
}

