/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.cml.MrvExport;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.modules.datatransfer.MarvinOLETransfer;
import chemaxon.marvin.sketch.History;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.util.OLEEmbeddable;
import chemaxon.struc.Molecule;
import chemaxon.util.ImageExportUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MarvinOLEPanel
extends JPanel
implements OLEEmbeddable {
    private static final long serialVersionUID = -6975415959061110410L;
    private static boolean DEBUG = false;
    private static Map<String, History> histories = new HashMap<String, History>();
    private MSketchPane msketch;
    private SketchPanel sketchPanel;
    private Logger log = ClipboardHandler.getLog();
    private boolean importExceptionCaught = false;

    public MarvinOLEPanel() {
        this.log.entering("MarvinOLEPanel", "MarvinOLEPanel");
        this.log.fine("Starting permanent resources.");
        MarvinOLETransfer.disablePermanentOLE();
        ClipboardHandler.startPermanentResources();
        this.log.fine("Initialization of permanent resources have been started.");
        try {
            this.log.fine("Setting LookAndFeel to: " + UIManager.getSystemLookAndFeelClassName());
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            this.log.fine("LookAndFeel has been set to:" + UIManager.getLookAndFeel().getName());
        }
        catch (Exception e) {
            this.log.throwing("MarvinOLEPanel", "MarvinOLEPanel", e);
        }
        this.init();
        this.log.exiting("MarvinOLEPanel", "MarvinOLEPanel");
    }

    private void init() {
        this.log.entering("MarvinOLEPanel", "init");
        this.log.fine("loading UserSettings");
        UserSettings settings = new UserSettings();
        this.log.fine("UserSettings loaded");
        settings.setProperty("customizationEnabled", "false", false);
        this.log.fine("CustomzationEnabled property set to false");
        this.log.fine("Constructing msketchPane");
        this.msketch = new MSketchPane(settings);
        this.log.fine("MSketchPane constructed");
        this.sketchPanel = (SketchPanel)this.msketch.getMolPanel();
        this.log.fine("SketchPanel recieved from pane");
        this.log.fine("set layout");
        this.setLayout(new BorderLayout());
        this.add((Component)this.sketchPanel, "Center");
        this.log.fine("layout has been set");
        this.getLeftToolBar().setFloatable(false);
        this.getTopToolBar().setFloatable(false);
        this.getBottomToolBar().setFloatable(false);
        this.getRightToolBar().setFloatable(false);
        this.log.fine("Toolbars are not floatable from now.");
        this.log.exiting("MarvinOLEPanel", "init");
    }

    public void release() {
        this.log.entering("MarvinOLEPanel", "release");
        ClipboardHandler.releasePermanentResources();
        this.log.exiting("MarvinOLEPanel", "release");
    }

    public Component getSketch() {
        this.log.entering("MarvinOLEPanel", "getSketch");
        return this.sketchPanel;
    }

    @Override
    public JToolBar getBottomToolBar() {
        this.log.entering("MarvinOLEPanel", "getBottomToolBar");
        return this.sketchPanel.getToolbar("mytemplates");
    }

    @Override
    public JToolBar getLeftToolBar() {
        this.log.entering("MarvinOLEPanel", "getLeftToolBar");
        return this.sketchPanel.getToolbar("tools");
    }

    @Override
    public JMenuBar getMainMenuBar() {
        this.log.entering("MarvinOLEPanel", "getMainMenuBar");
        return this.msketch.getJMenuBar();
    }

    @Override
    public JToolBar getRightToolBar() {
        this.log.entering("MarvinOLEPanel", "getRightToolBar");
        return this.sketchPanel.getToolbar("atoms");
    }

    @Override
    public JToolBar getTopToolBar() {
        this.log.entering("MarvinOLEPanel", "getTopToolBar");
        return this.sketchPanel.getToolbar("general");
    }

    @Override
    public void repaintAll() {
        this.log.entering("MarvinOLEPanel", "repaintAll");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MarvinOLEPanel.this.log.entering("MarvinOLEPanel$1", "run");
                MarvinOLEPanel.this.invalidate();
                MarvinOLEPanel.this.log.fine("Contents invalidated.");
                MarvinOLEPanel.this.sketchPanel.repaint();
                MarvinOLEPanel.this.getTopToolBar().repaint();
                MarvinOLEPanel.this.getBottomToolBar().repaint();
                MarvinOLEPanel.this.getLeftToolBar().repaint();
                MarvinOLEPanel.this.getRightToolBar().repaint();
                MarvinOLEPanel.this.getMainMenuBar().repaint();
                MarvinOLEPanel.this.log.fine("Contents repainted");
                MarvinOLEPanel.this.log.exiting("MarvinOLEPanel$1", "run");
            }
        });
        this.log.exiting("MarvinOLEPanel", "repaintAll");
    }

    public String getMOL() {
        this.log.entering("MarvinOLEPanel", "getMOL");
        String molstr = null;
        try {
            molstr = MolExporter.exportToFormat(this.msketch.getMol().getDocument(), "mol");
            this.log.fine("Returned molStr:" + molstr);
        }
        catch (IOException e) {
            this.log.throwing("MarvinOLEPanel", "getMOL", e);
        }
        return molstr;
    }

    public String getSmiles() {
        this.log.entering("MarvinOLEPanel", "getSmiles");
        String molstr = null;
        try {
            molstr = MolExporter.exportToFormat(this.msketch.getMol().getDocument(), "smiles");
            this.log.fine("Returned molStr:" + molstr);
        }
        catch (IOException e) {
            this.log.throwing("MarvinOLEPanel", "getSmiles", e);
        }
        return molstr;
    }

    public String getMRV() {
        this.log.entering("MarvinOLEPanel", "getMRV");
        boolean tmp = this.msketch.getMolPanel().getSaveGlobalGUIProperties();
        this.msketch.getMolPanel().setSaveGlobalGUIProperties(true);
        StringBuilder molstr = new StringBuilder();
        this.log.fine("Export has been set up.");
        try {
            MrvExport cv = (MrvExport)MFileFormatUtil.createExportModule("mrv");
            cv.setGlobalGUIProperties(this.msketch.getMolPanel().getGlobalGUIProperties());
            molstr.append((String)cv.open("mrv"));
            molstr.append((String)cv.convert(this.msketch.getMol()));
            molstr.append((String)cv.close());
            this.log.fine("Export ended returning the following MRV: " + molstr.toString());
        }
        catch (MolExportException e) {
            this.log.throwing("MarvinOLEPanel", "getMRV", e);
        }
        this.log.fine("Fix exporter setup.");
        this.msketch.getMolPanel().setSaveGlobalGUIProperties(tmp);
        this.log.exiting("MarvinOLEPanel", "getMRV");
        return molstr.toString();
    }

    public byte[] getSkc() {
        this.log.entering("MarvinOLEPanel", "getSkc");
        byte[] molsrc = null;
        try {
            molsrc = MolExporter.exportToBinFormat(this.msketch.getMol().getDocument(), "skc");
            this.log.fine("Returned mol:" + molsrc);
        }
        catch (IOException e) {
            this.log.throwing("MarvinOLEPanel", "getSkc", e);
        }
        if (molsrc == null) {
            molsrc = new byte[]{};
        }
        return molsrc;
    }

    public byte[] getCdx() {
        this.log.entering("MarvinOLEPanel", "getCdx");
        byte[] molsrc = null;
        try {
            molsrc = MolExporter.exportToBinFormat(this.msketch.getMol().getDocument(), "cdx");
            this.log.fine("Returned mol:" + molsrc);
        }
        catch (IOException e) {
            this.log.throwing("MarvinOLEPanel", "getCdx", e);
        }
        if (molsrc == null) {
            molsrc = new byte[]{};
        }
        return molsrc;
    }

    public void setMRV(String src) {
        this.log.entering("MarvinOLEPanel", "setMRV");
        this.setMRV(src, "default");
        this.log.exiting("MarvinOLEPanel", "setMRV");
    }

    public void setMOL(String src) {
        this.log.entering("MarvinOLEPanel", "setMOL");
        this.setMOL(src, "default");
        this.log.exiting("MarvinOLEPanel", "setMOL");
    }

    public void setSmiles(String src) {
        this.log.entering("MarvinOLEPanel", "setSmiles");
        this.setSmiles(src, "default");
        this.log.exiting("MarvinOLEPanel", "setSmiles");
    }

    private void setMolecule(String src, String id, String format2) {
        this.setMolecule(src.getBytes(), id, format2);
    }

    private void setMolecule(final byte[] src, final String id, final String format2) {
        this.log.entering("MarvinOLEPanel", "setMolecule");
        this.importExceptionCaught = false;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MarvinOLEPanel.this.log.entering("MarvinOLEPanel$2", "run");
                    if (src == null) {
                        MarvinOLEPanel.this.log.fine("Molecule source is null, returning.");
                        return;
                    }
                    if (histories.get(id) != null) {
                        MarvinOLEPanel.this.log.fine("Setting history information for Panel.");
                        MarvinOLEPanel.this.sketchPanel.setHistory((History)histories.get(id));
                        MarvinOLEPanel.this.sketchPanel.getCanvas().getEditor().setHistorizeEnabled(false);
                        MarvinOLEPanel.this.log.fine("History information set, HistorizeEnabled false for this Molecule.");
                    } else {
                        MarvinOLEPanel.this.log.fine("Create history information for panel.");
                        History h = new History();
                        MarvinOLEPanel.this.log.fine("Setting new empty history for panel.");
                        MarvinOLEPanel.this.sketchPanel.setHistory(h);
                        MarvinOLEPanel.this.log.fine("Store histroy in own cache.");
                        histories.put(id, h);
                    }
                    Molecule mol = null;
                    try {
                        MarvinOLEPanel.this.log.fine("Importing molecule source: " + src);
                        mol = MolImporter.importMol(src, format2, null);
                        if (mol.getDim() < 2) {
                            Cleaner.clean(mol, 2, null);
                        }
                    }
                    catch (MolFormatException e) {
                        MarvinOLEPanel.this.importExceptionCaught = true;
                        MarvinOLEPanel.this.log.throwing("MarvinOLEPanel$2", "run", e);
                    }
                    MarvinOLEPanel.this.log.fine("Setting molecule on MSketch");
                    MarvinOLEPanel.this.msketch.setMol(mol);
                    MarvinOLEPanel.this.log.fine("Molecule is set.");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MarvinOLEPanel.this.log.entering("MarvinOLEPanel$2$1", "run");
                            MarvinOLEPanel.this.log.fine("Setting HistorizeEnabled to true.");
                            MarvinOLEPanel.this.sketchPanel.getCanvas().getEditor().setHistorizeEnabled(true);
                            MarvinOLEPanel.this.log.exiting("MarvinOLEPanel$2$1", "run");
                        }
                    });
                    MarvinOLEPanel.this.log.exiting("MarvinOLEPanel$2", "run");
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.log.exiting("MarvinOLEPanel", "setMolecule");
    }

    public void setMRV(String src, String id) {
        this.log.entering("MarvinOLEPanel", "setMRV(String, String)");
        this.setMolecule(src, id, "mrv");
        this.log.exiting("MarvinOLEPanel", "setMRV(String,String)");
    }

    public void setMOL(String src, String id) {
        this.log.entering("MarvinOLEPanel", "setMOL(String, String)");
        this.setMolecule(src, id, "mol");
        this.log.exiting("MarvinOLEPanel", "setMOL(String, String)");
    }

    public void setSmiles(String src, String id) {
        this.log.entering("MarvinOLEPanel", "setMOL(String, String)");
        this.setMolecule(src, id, "smiles");
        this.log.exiting("MarvinOLEPanel", "setMOL(String, String)");
    }

    public boolean setSkc(byte[] src, String id) {
        this.log.entering("MarvinOLEPanel", "setSkc(byte[], String)");
        this.setMolecule(src, id, "skc");
        this.log.finest("setSkc(byte[], String) returning:" + this.importExceptionCaught);
        return !this.importExceptionCaught;
    }

    public boolean setCdx(byte[] src, String id) {
        this.log.entering("MarvinOLEPanel", "setCdx(byte[], String)");
        this.setMolecule(src, id, "cdx");
        this.log.finest("setCdx(byte[], String) returning:" + this.importExceptionCaught);
        return !this.importExceptionCaught;
    }

    public void centralizeMoleculeDisplay() {
        this.log.entering("MarvinOLEPanel", "centralizeMoleculeDisplay");
        this.sketchPanel.centralizeMoleculeDisplay();
        this.log.exiting("MarvinOLEPanel", "centralizeMoleculeDisplay");
    }

    public byte[] getEMF(int width, int height) {
        this.log.entering("MarvinOLEPanel", "getEMF");
        byte[] result = null;
        this.log.fine("Getting parameters for exporter");
        String params = this.getParamsToExporter(width, height);
        this.log.fine("Parameters gathered.");
        try {
            this.log.fine("Create EMF stream.");
            result = this.createEMFStream(params);
        }
        catch (MolExportException e) {
            this.log.throwing("MarvinOLEPanel", "getEMF", e);
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.log.throwing("MarvinOLEPanel", "getEMF", e);
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        catch (IOException e) {
            this.log.throwing("MarvinOLEPanel", "getEMF", e);
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        if (result == null) {
            this.log.fine("Result is null, returning empty bzte[]");
            result = new byte[]{};
        }
        if (DEBUG) {
            this.log.fine("Create oleexit.emf for debugging.");
            try {
                FileOutputStream fout = new FileOutputStream("oleexit.emf");
                fout.write(result);
                fout.close();
            }
            catch (IOException ioex) {
                this.log.throwing("MarvinOLEPanel", "getEMF", ioex);
                System.err.println("Cannot write into oleexit.emf");
            }
        }
        this.log.exiting("MarvinOLEPanel", "getEMF");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createEMFStream(String params) throws MolExportException, IOException {
        this.log.entering("MarvinOLEPanel", "createEMFStream");
        MolExporter exporter = null;
        byte[] res = null;
        this.log.fine("Getting Molecule from MSketch");
        Molecule m = this.msketch.getMol();
        int n = m.getAtomCount();
        this.log.fine("Unselecting atoms.");
        for (int i = 0; i < n; ++i) {
            m.getAtom(i).setSelected(false);
        }
        this.log.fine("Export molecule to MRV format.");
        String mrvSource = MolExporter.exportToFormat(m, "mrv");
        this.log.fine("Creating EMF from MRV.");
        res = ImageExportUtil.createEMF(mrvSource, params);
        this.log.fine("New emf generator returned.");
        if (res == null) {
            this.log.fine("New emf generator returned null, fallback to freehep.");
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                this.log.fine("Exporting with freehep.");
                exporter = new MolExporter(stream, params);
                exporter.write(m);
                exporter.close();
                this.log.fine("Exporting with freehep finished.");
                res = stream.toByteArray();
            }
            finally {
                if (exporter != null) {
                    try {
                        this.log.fine("Closing exporter, there was a failure, exeption has been thrown.");
                        exporter.close();
                    }
                    catch (MolExportException e) {
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.log.exiting("MarvinOLEPanel", "createEMFStream");
        return res;
    }

    private String getParamsToExporter(int w, int h) {
        this.log.entering("MarvinOLEPanel", "getParamsToExporter");
        boolean tmp = this.msketch.getUserSettings().getSaveGUIPropertiesInMRV();
        this.msketch.getUserSettings().setSaveGUIPropertiesInMRV(true);
        Rectangle r = w <= 0 || h <= 0 ? this.sketchPanel.getEditor().getPainter().getBoundsFor(this.msketch.getMol().getDocument(), this.sketchPanel.getEditor().getPainter().getScale()) : new Rectangle(w, h);
        this.log.fine("Merging various properties to one Property object.");
        Properties settings = ImageExportUtil.mergeProperties(this.msketch.getUserSettings(), this.msketch.getMolPanel().getGlobalGUIProperties(), r);
        settings.setProperty("transbg", "true");
        this.msketch.getUserSettings().setSaveGUIPropertiesInMRV(tmp);
        this.log.fine("Creating parameter string for exporter.");
        String result = ImageExportUtil.createImageExporterParameter(settings, "emf:ole,", this.msketch.getMol().getDocument());
        this.log.fine("ExporterParameters: " + result);
        this.log.exiting("MarvinOLEPanel", "getParamsToExporter");
        return result;
    }
}

