/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.util.IntRange;
import chemaxon.util.MolFilter;
import chemaxon.util.iterator.MoleculeIterator;
import chemaxon.util.iterator.MoleculeIteratorFactory;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class MolFragLoader {
    private MoleculeIterator iterator = null;
    private IntRange range = null;
    private MolFilter filter = null;
    public static MolFilter FILTER_ONE_ATTACHMENT = new RgroupAttachmentCountFilter(1);
    public static MolFilter FILTER_TWO_ATTACHMENTS = new RgroupAttachmentCountFilter(2);

    public MolFragLoader() {
    }

    public MolFragLoader(MolImporter importer) {
        this(MoleculeIteratorFactory.getMoleculeIterator(importer));
    }

    public MolFragLoader(MoleculeIterator iterator) {
        this.setIterator(iterator);
    }

    public void setImporter(MolImporter importer) {
        this.setIterator(MoleculeIteratorFactory.getMoleculeIterator(importer));
    }

    public void setIterator(MoleculeIterator iterator) {
        this.iterator = iterator;
    }

    public void setRange(IntRange range) {
        this.range = range;
    }

    public void setFilter(MolFilter filter) {
        this.filter = filter;
    }

    public Molecule loadFrags() {
        return this.loadFrags(true);
    }

    public Molecule loadFrags(boolean arrange) {
        Molecule mol = new Molecule();
        this.loadFrags(mol, -1, arrange);
        return mol;
    }

    public void loadFrags(MoleculeGraph mol, boolean arrange) {
        this.loadFrags(mol, mol.getDim(), arrange);
    }

    public void loadFrags(MoleculeGraph mol, int dim, boolean arrange) {
        MolIterator molIterator = new MolIterator();
        Molecule frag = null;
        if (arrange) {
            int i;
            ArrayList<MoleculeGraph> fragList = new ArrayList<MoleculeGraph>();
            if (!mol.isEmpty()) {
                fragList.add(mol);
            }
            while ((frag = molIterator.next()) != null) {
                if (dim == -1) {
                    dim = frag.getDim();
                }
                MolFragLoader.cleanIfNeeded(frag, dim);
                fragList.add(frag);
            }
            MolFragLoader.cleanIfNeeded(mol, dim);
            MoleculeGraph[] frags = new MoleculeGraph[fragList.size()];
            fragList.toArray(frags);
            if (dim != 0) {
                CleanUtil.arrangeMolecules(frags, 2, -1);
            }
            int n = i = mol.isEmpty() ? 0 : 1;
            while (i < frags.length) {
                mol.fuse(frags[i]);
                ++i;
            }
        } else {
            if (dim != -1) {
                MolFragLoader.cleanIfNeeded(mol, dim);
            }
            while ((frag = molIterator.next()) != null) {
                if (dim == -1) {
                    dim = frag.getDim();
                    MolFragLoader.cleanIfNeeded(mol, dim);
                }
                MolFragLoader.cleanIfNeeded(frag, dim);
                mol.fuse(frag);
            }
        }
    }

    public void loadRgroupMembers(RgMolecule mol, int rgroupID) {
        MolIterator molIterator = new MolIterator();
        Molecule frag = null;
        int dim = mol.getDim();
        while ((frag = molIterator.next()) != null) {
            MolFragLoader.cleanIfNeeded(frag, dim);
            mol.addRgroup(rgroupID, frag);
        }
    }

    public void arrangeRgroupMembers(RgMolecule mol) {
        CleanUtil.arrangeComponents(mol);
    }

    private static void cleanIfNeeded(MoleculeGraph m, int dim) {
        if (dim != m.getDim()) {
            if (dim != 0) {
                m.clean(dim, null);
            } else {
                m.setDim(0);
            }
        }
    }

    class MolIterator {
        private int molIndex = 0;

        MolIterator() {
        }

        Molecule next() {
            Molecule mol = null;
            int count = 1;
            do {
                if (MolFragLoader.this.range != null) {
                    if (!MolFragLoader.this.range.hasNext()) {
                        return null;
                    }
                    int next = MolFragLoader.this.range.next();
                    count = next - this.molIndex;
                    this.molIndex = next;
                }
                for (int i = 0; i < count; ++i) {
                    if (MolFragLoader.this.iterator.hasNext()) {
                        try {
                            mol = MolFragLoader.this.iterator.next();
                        }
                        catch (NoSuchElementException e) {
                            mol = null;
                        }
                        continue;
                    }
                    return null;
                }
                if (mol == null) {
                    return this.next();
                }
                if (!(mol instanceof RgMolecule)) continue;
                mol = ((RgMolecule)mol).getRoot();
            } while (MolFragLoader.this.filter != null && !MolFragLoader.this.filter.accept(mol));
            return mol;
        }
    }

    public static class RgroupAttachmentCountFilter
    implements MolFilter {
        private int attachmentCount = 0;

        public RgroupAttachmentCountFilter(int attachmentCount) {
            this.attachmentCount = attachmentCount;
        }

        @Override
        public boolean accept(Molecule mol) {
            return MolImportUtil.countAttachments(mol) == this.attachmentCount;
        }
    }
}

