/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.common.util.IntVector;
import chemaxon.core.util.GeomUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.VMNAttributeUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MPoint;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class MolImportUtil {
    private static final String ORDER = "ORDER R";
    private static final String ATTACH = "ATTACH";
    private static final String SEPARATOR = ",";

    public static void addProperties(MPropertyContainer target, MPropertyContainer source) {
        if (target != source) {
            for (int i = 0; i < source.size(); ++i) {
                String key = source.getKey(i);
                MProp p = source.get(key);
                target.set(key, p);
            }
        }
    }

    public static void fixBeilsteinRDF(Molecule mol) {
        if (mol == null) {
            return;
        }
        if (!mol.isEmpty()) {
            return;
        }
        MPropertyContainer props = mol.properties();
        String[] keys = props.getKeys();
        Molecule realmol = null;
        ArrayList<Object> v = new ArrayList<Object>();
        for (int i = 0; i < keys.length; ++i) {
            Object o = props.getObject(keys[i]);
            if (o == null) continue;
            if (realmol == null && o instanceof Molecule) {
                realmol = (Molecule)o;
            }
            v.add(keys[i]);
            v.add(o);
        }
        if (realmol != null) {
            if (mol instanceof RgMolecule && !(realmol instanceof RgMolecule)) {
                RgMolecule rgmol = (RgMolecule)mol;
                rgmol.setRoot(realmol);
            } else {
                realmol.clonecopy(mol);
            }
            for (int i = 0; i < v.size(); i += 2) {
                String key = (String)v.get(i);
                Object o = v.get(i + 1);
                if (o == realmol) {
                    Molecule m = mol instanceof RgMolecule ? ((RgMolecule)mol).getRoot() : mol;
                    mol.setPropertyObject(key, m);
                    continue;
                }
                mol.setPropertyObject(key, o);
            }
        }
    }

    public static void setSgroupParentSgroups(Molecule mol) throws IOException {
        ArrayList<Sgroup> v = new ArrayList<Sgroup>();
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup gi = mol.getSgroup(i);
            if (gi.getType() == 10) continue;
            int ni = gi.getAtomCount();
            v.clear();
            for (int j = 0; j < mol.getSgroupCount(); ++j) {
                if (j == i) continue;
                Sgroup gj = mol.getSgroup(j);
                int nj = gj.getAtomCount();
                if (!gi.containsAllAtomsOf(gj)) continue;
                if (nj < ni || nj == ni && j < i) {
                    v.add(gj);
                    continue;
                }
                if (nj <= ni) continue;
                throw new MolFormatException("a parent S-group has smaller number of atoms than its child");
            }
            if (v.size() == 0) continue;
            MolImportUtil.setSgroupParentSgroups(gi, v);
        }
    }

    private static void setSgroupParentSgroups(Sgroup gi, List<Sgroup> v) throws IOException {
        Sgroup gj;
        int j;
        for (j = 0; j < v.size(); ++j) {
            gj = v.get(j);
            int nj = gj.getAtomCount();
            for (int k = v.size() - 1; k >= 0; --k) {
                if (j == k) continue;
                Sgroup gk = v.get(k);
                int nk = gk.getAtomCount();
                if (!gj.containsAllAtomsOf(gk)) continue;
                if (nk <= nj) {
                    v.remove(k);
                    if (k >= j) continue;
                    --j;
                    continue;
                }
                throw new IOException("a parent S-group does not have greater number of atoms than its child");
            }
        }
        for (j = 0; j < v.size(); ++j) {
            gj = v.get(j);
            if (gj.getParentSgroup() != null) continue;
            gi.addChildSgroup(gj);
        }
    }

    public static void reparentEmptySgroups(Molecule mol) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sg = mol.getSgroup(i);
            Molecule parentMol = sg.getParentMolecule();
            for (int j = 0; j < sg.getChildSgroupCount(); ++j) {
                if (parentMol.indexOf(sg.getChildSgroup(j)) != -1) continue;
                parentMol.addSgroup(sg.getChildSgroup(j), true);
            }
        }
    }

    public static void recalcBrackets(Molecule mol, double bondlength) {
        boolean oldState = mol.isGUIContracted();
        mol.setGUIContracted(true);
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sg = mol.getSgroup(i);
            ArrayList<MBracket> brackets = sg.getBrackets();
            MBracket bracket = null;
            if (sg.getBracketCount() != 2) continue;
            DPoint3[] p = new DPoint3[4];
            MolImportUtil.checkBracketOrientation(brackets.get(0), sg, bondlength);
            MolImportUtil.checkBracketOrientation(brackets.get(1), sg, bondlength);
            p[0] = brackets.get(0).getPoint(0).getLocation();
            p[1] = brackets.get(0).getPoint(3).getLocation();
            p[2] = brackets.get(1).getPoint(0).getLocation();
            p[3] = brackets.get(1).getPoint(3).getLocation();
            if (sg instanceof RepeatingUnitSgroup) {
                if (sg.findCrossingBonds() == null || DrawingUtil.isRectangle(p[0], p[1], p[2], p[3])) {
                    bracket = new MBracket(new MPoint(DrawingUtil.findTopLeft(p)), new MPoint(DrawingUtil.findBottomRight(p)));
                    bracket.setType(brackets.get(0).getType());
                }
            } else {
                bracket = new MBracket(new MPoint(DrawingUtil.findTopLeft(p)), new MPoint(DrawingUtil.findBottomRight(p)));
                bracket.setType(brackets.get(0).getType());
            }
            if (bracket == null) continue;
            bracket.setBracketOrientation(5);
            sg.initBrackets();
            sg.addBracket(bracket);
        }
        mol.setGUIContracted(oldState);
    }

    private static void checkBracketOrientation(MBracket bracket, Sgroup sg, double bondlength) {
        DPoint3[] p = new DPoint3[]{bracket.getPoint(0).getLocation(), bracket.getPoint(3).getLocation()};
        MolBond[] b = sg.findCrossingBonds();
        MolBond[] bonds = GeomUtil.getCrossingBonds(b, p[0], p[1], false);
        if (bonds.length > 0) {
            MolImportUtil.setBracketEndPoints(bracket, p, bondlength, sg, b);
        }
    }

    public static void readBrackets(Sgroup sg, DPoint3[] p, boolean use3D, double blen) {
        MBracket bracket = null;
        if (sg instanceof RepeatingUnitSgroup && sg.findCrossingBonds().length != 0) {
            RepeatingUnitSgroup sru = (RepeatingUnitSgroup)sg;
            MolBond[] b = sru.findCrossingBonds();
            MolBond[] bonds = GeomUtil.getCrossingBonds(b, p[0], p[1], use3D);
            if (sru.getAtomCount() > 0) {
                bracket = new MBracket();
                bracket = MolImportUtil.setBracketEndPoints(bracket, p, blen, sru, bonds);
                bracket.setBracketOrientation(4);
                bracket.setType(1);
                if (bonds.length == 2) {
                    if (sru.getHeadCrossingBonds() == null) {
                        sru.setHeadCrossingBonds(bonds);
                    } else if (!sru.equalsHead(bonds) && sru.getTailCrossingBonds() == null) {
                        sru.setTailCrossingBonds(bonds);
                    }
                }
                bracket.setType(1);
                sru.addBracket(bracket);
            } else {
                CleanUtil.generateBracketCoords(sru, 1, false);
            }
        } else {
            bracket = new MBracket();
            DPoint3[] r = CleanUtil.calcBracketEndPoints(p, sg.getAtom(0).getLocation(), blen);
            MPoint[] points = new MPoint[]{new MPoint(p[0]), new MPoint(r[0]), new MPoint(r[1]), new MPoint(p[1])};
            bracket.setPoints(points);
            bracket.setType(1);
            bracket.setBracketOrientation(4);
            sg.addBracket(bracket);
        }
    }

    private static MBracket setBracketEndPoints(MBracket bracket, DPoint3[] p, double blen, Sgroup sru, MolBond[] bonds) {
        MolAtom innerAtom = null;
        innerAtom = bonds.length > 0 ? (sru.indexOf(bonds[0].getAtom1()) >= 0 ? bonds[0].getAtom1() : bonds[0].getAtom2()) : sru.getAtom(0);
        DPoint3[] r = CleanUtil.calcBracketEndPoints(p, innerAtom.getLocation(), blen);
        MPoint[] points = new MPoint[]{new MPoint(p[0]), new MPoint(r[0]), new MPoint(r[1]), new MPoint(p[1])};
        bracket.setPoints(points);
        return bracket;
    }

    public static void generateBrackets(Molecule mol) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            if (mol.getSgroup(i).getBracketCount() != 0) continue;
            CleanUtil.generateBracketCoords(mol.getSgroup(i), 1);
        }
    }

    public static void convertRgroupAttachments(Molecule mol) {
        boolean isGUIContracted = mol.isGUIContracted();
        mol.setGUIContracted(false);
        if (MolImportUtil.hasDataSgroupAttachment(mol) && mol instanceof RgMolecule) {
            MolImportUtil.convertAllRgroupAttachments((RgMolecule)mol);
            VMNAttributeUtil.convertAtomAttributes(mol);
        } else {
            MolImportUtil.convertSgroupLikeRgroupAttachments(mol);
        }
        mol.setGUIContracted(isGUIContracted);
    }

    private static boolean hasDataSgroupAttachment(Molecule mol) {
        for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
            String key;
            Sgroup sgroup = mol.getSgroup(i);
            if (sgroup.getType() != 10 || !(key = ((DataSgroup)sgroup).getFieldName()).startsWith(ORDER) && !key.equals(ATTACH)) continue;
            return true;
        }
        return false;
    }

    private static void clearDataSgroupAttachments(Molecule mol) {
        int i;
        for (i = mol.getSgroupCount() - 1; i >= 0; --i) {
            String key;
            Sgroup sgroup = mol.getSgroup(i);
            if (sgroup.getType() != 10 || !(key = ((DataSgroup)sgroup).getFieldName()).startsWith(ORDER) && !key.equals(ATTACH)) continue;
            mol.ungroupSgroup(sgroup);
        }
        for (i = mol.getGraphUnion().getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() != 138) continue;
            atom.clearProperties();
        }
    }

    private static void convertAllRgroupAttachments(RgMolecule rgmol) {
        int i;
        int count = rgmol.getGraphUnion().getAtomCount();
        for (i = 0; i < count; ++i) {
            MolAtom atom = rgmol.getAtom(i);
            if (atom.getAtno() != 134) continue;
            MolImportUtil.convertAllRgroupAttachments(rgmol, atom);
        }
        for (i = rgmol.getRgroupCount() - 1; i >= 0; --i) {
            Molecule m;
            for (int j = rgmol.getRgroupMemberCount(i) - 1; j >= 0 && !MolImportUtil.hasAttachment(m = rgmol.getRgroupMember(i, j)); --j) {
                MolImportUtil.convertAllRgroupAttachmentsInMember(rgmol, m, null);
            }
        }
        MolImportUtil.convertAllRgroupAttachmentsInMember(rgmol, rgmol.getRoot(), null);
        MolImportUtil.clearDataSgroupAttachments(rgmol);
    }

    private static void convertAllRgroupAttachments(RgMolecule rgmol, MolAtom ratom) {
        int rid = ratom.getRgroup();
        int rgindex = rgmol.findRgroupIndex(rid);
        if (rgindex == -1) {
            return;
        }
        if (!MolImportUtil.setLigandOrdersByOrderData(ratom)) {
            MolImportUtil.setLigandOrdersByAtomIndex(rgmol, ratom);
        }
        if (MolImportUtil.hasAttachment(rgmol, rgindex)) {
            return;
        }
        int memberCount = rgmol.getRgroupMemberCount(rgindex);
        ArrayList<MolAtom> ratoms = new ArrayList<MolAtom>();
        for (int i = 0; i < memberCount; ++i) {
            Molecule m = rgmol.getRgroupMember(rgindex, i);
            MolImportUtil.addRAtoms(ratoms, m);
            MolImportUtil.convertAllRgroupAttachmentsInMember(rgmol, m, ratom);
        }
        for (MolAtom atom : ratoms) {
            MolImportUtil.convertAllRgroupAttachments(rgmol, atom);
        }
    }

    private static int convertAllRgroupAttachmentsInMember(RgMolecule rgmol, Molecule m, MolAtom ratom) {
        MolAtom atom;
        int attachmentCount = 0;
        for (int j = m.getSgroupCount() - 1; j >= 0; --j) {
            int[] orders;
            DataSgroup dsg;
            String key;
            Sgroup sgroup = m.getSgroup(j);
            if (sgroup.getType() != 10 || !(key = (dsg = (DataSgroup)sgroup).getFieldName()).equals(ATTACH)) continue;
            atom = dsg.getAtom(0);
            for (int order : orders = MolImportUtil.getAttachmentData(dsg.getData())) {
                MolImportUtil.addCleanedRgroupAttachmentPoint(atom, order, 1);
            }
            attachmentCount += orders.length;
        }
        if (ratom == null || attachmentCount < ratom.getBondCount()) {
            attachmentCount += MolImportUtil.convertSgroupLikeRgroupAttachmentsInMember(rgmol, m);
        }
        if (ratom != null && m.getAtomCount() == 1) {
            MolAtom atom2 = m.getAtom(0);
            attachmentCount = ratom.getBondCount();
            for (int order = 1; order <= attachmentCount; ++order) {
                MolImportUtil.addCleanedRgroupAttachmentPoint(atom2, order, 1);
            }
        }
        if (ratom != null) {
            int rid = ratom.getRgroup();
            MolAtom[] attachments = MolImportUtil.getAttachments(m);
            int count = Math.min(ratom.getBondCount(), attachments.length);
            for (int j = 0; j < count; ++j) {
                atom = attachments[j].getLigand(0);
                if (atom.getAtno() != 134) continue;
                MolImportUtil.copyOrderData(ratom.getLigand(j), attachments[j], rid);
            }
        }
        return attachmentCount;
    }

    private static void copyOrderData(MolAtom from, MolAtom to, int rid) {
        Molecule mol = (Molecule)from.getParent();
        Sgroup[] sgroups = mol.findAllSgroupContaining(from);
        for (int i = 0; i < sgroups.length; ++i) {
            DataSgroup dsg;
            String key;
            if (sgroups[i].getType() != 10 || !(key = (dsg = (DataSgroup)sgroups[i]).getFieldName()).startsWith(ORDER) || key.endsWith("" + rid)) continue;
            to.putProperty(key, dsg.getData());
        }
    }

    private static DataSgroup getOrderData(MolAtom atom, int rid) {
        Molecule mol = (Molecule)atom.getParent();
        Sgroup[] sgroups = mol.findAllSgroupContaining(atom);
        for (int i = 0; i < sgroups.length; ++i) {
            DataSgroup dsg;
            String key;
            if (sgroups[i].getType() != 10 || !(key = (dsg = (DataSgroup)sgroups[i]).getFieldName()).equals(ORDER + rid)) continue;
            return dsg;
        }
        return null;
    }

    private static int[] getAttachmentData(String data) {
        if (data == null) {
            return new int[0];
        }
        return MolImportUtil.convertToInt(data.split(SEPARATOR));
    }

    private static int[] convertToInt(String[] data) {
        int[] intData = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            intData[i] = Integer.parseInt(data[i]);
        }
        return intData;
    }

    private static boolean setLigandOrdersByOrderData(MolAtom ratom) {
        int bondCount = ratom.getBondCount();
        if (bondCount == 0) {
            return true;
        }
        if (bondCount == 1) {
            ratom.setLigandOrder(1, ratom.getLigand(0));
            return true;
        }
        int rid = ratom.getRgroup();
        for (int i = bondCount - 1; i >= 0; --i) {
            MolAtom ligand = ratom.getLigand(i);
            int order = 0;
            if (ligand.getAtno() == 138) {
                String prop = (String)ligand.getProperty(ORDER + rid);
                if (prop != null) {
                    order = Integer.parseInt(prop);
                }
            } else {
                DataSgroup dsg = MolImportUtil.getOrderData(ligand, rid);
                if (dsg != null) {
                    order = Integer.parseInt(dsg.getData());
                }
            }
            if (order == 0) {
                return false;
            }
            ratom.setLigandOrder(order, ligand);
        }
        return true;
    }

    public static void convertSgroupLikeRgroupAttachments(Molecule mol) {
        if (MolImportUtil.hasAttachment(mol.getGraphUnion())) {
            return;
        }
        if (mol instanceof RgMolecule) {
            int i;
            RgMolecule rgmol = (RgMolecule)mol;
            int count = rgmol.getGraphUnion().getAtomCount();
            for (i = 0; i < count; ++i) {
                MolAtom atom = rgmol.getAtom(i);
                if (atom.getAtno() != 134) continue;
                MolImportUtil.convertSgroupLikeRgroupAttachments(rgmol, atom);
            }
            for (i = rgmol.getRgroupCount() - 1; i >= 0; --i) {
                Molecule m;
                for (int j = rgmol.getRgroupMemberCount(i) - 1; j >= 0 && !MolImportUtil.hasAttachment(m = rgmol.getRgroupMember(i, j)); --j) {
                    MolImportUtil.convertSgroupLikeRgroupAttachmentsInMember(rgmol, m);
                }
            }
        }
        MolImportUtil.convertSgroupLikeRgroupAttachmentsInMember(null, mol);
    }

    private static void convertSgroupLikeRgroupAttachments(RgMolecule rgmol, MolAtom ratom) {
        int rid = ratom.getRgroup();
        int rgindex = rgmol.findRgroupIndex(rid);
        if (rgindex == -1) {
            return;
        }
        MolImportUtil.setLigandOrdersByAtomIndex(rgmol, ratom);
        if (MolImportUtil.hasAttachment(rgmol, rgindex)) {
            return;
        }
        int memberCount = rgmol.getRgroupMemberCount(rgindex);
        ArrayList<MolAtom> ratoms = new ArrayList<MolAtom>();
        for (int i = 0; i < memberCount; ++i) {
            Molecule m = rgmol.getRgroupMember(rgindex, i);
            MolImportUtil.addRAtoms(ratoms, m);
            MolImportUtil.convertSgroupLikeRgroupAttachmentsInMember(rgmol, m);
        }
        for (MolAtom atom : ratoms) {
            if (!MolImportUtil.isValidRgroupAtom(rid, atom)) continue;
            MolImportUtil.convertSgroupLikeRgroupAttachments(rgmol, atom);
        }
    }

    public static boolean isValidRgroupAtom(int rid, MolAtom atom) {
        return atom.getAtno() != 134 || rid != atom.getRgroup();
    }

    private static void addRAtoms(ArrayList<MolAtom> ratoms, Molecule m) {
        for (int j = m.getAtomCount() - 1; j >= 0; --j) {
            MolAtom atom = m.getAtom(j);
            if (atom.getAtno() != 134) continue;
            ratoms.add(atom);
        }
    }

    private static int convertSgroupLikeRgroupAttachmentsInMember(RgMolecule rgmol, Molecule m) {
        MolAtom attachAtom1 = null;
        MolAtom attachAtom2 = null;
        MolAtom sgAtom1 = null;
        MolAtom sgAtom2 = null;
        block9: for (int j = m.getAtomCount() - 1; j >= 0; --j) {
            MolAtom atom = m.getAtom(j);
            int attach = atom.getAttach();
            if (attach == 0) continue;
            SuperatomSgroup sgroup = MolImportUtil.getContainingSuperatomSgroup(atom);
            if (sgroup == null) {
                switch (attach) {
                    case 1: {
                        attachAtom1 = atom;
                        break;
                    }
                    case 2: {
                        attachAtom2 = atom;
                        break;
                    }
                    case 3: {
                        attachAtom1 = atom;
                        attachAtom2 = atom;
                    }
                }
                atom.setAttach(0);
                continue;
            }
            if (rgmol == null || rgmol.rgroupIdOf(atom) == -1) continue;
            switch (MolImportUtil.getFreeRgroupAttachmentCount(atom, sgroup)) {
                case 1: {
                    if (sgAtom1 == null) {
                        sgAtom1 = atom;
                        continue block9;
                    }
                    if (sgAtom2 != null) continue block9;
                    sgAtom2 = atom;
                    continue block9;
                }
                case 2: {
                    sgAtom1 = atom;
                    sgAtom2 = atom;
                }
            }
        }
        if (attachAtom1 == null) {
            attachAtom1 = sgAtom1;
            if (attachAtom2 == null) {
                attachAtom2 = sgAtom2;
            }
        } else if (attachAtom2 == null) {
            attachAtom2 = sgAtom1;
        }
        int attachmentCount = 0;
        if (attachAtom1 != null) {
            MolImportUtil.addCleanedRgroupAttachmentPoint(attachAtom1, 1, 1);
            ++attachmentCount;
        }
        if (attachAtom2 != null) {
            MolImportUtil.addCleanedRgroupAttachmentPoint(attachAtom2, 2, 1);
            ++attachmentCount;
        }
        return attachmentCount;
    }

    public static int getFreeRgroupAttachmentCount(MolAtom atom) {
        int attach = atom.getAttach();
        if (attach == 0) {
            return 0;
        }
        return MolImportUtil.getFreeRgroupAttachmentCount(atom, MolImportUtil.getContainingSuperatomSgroup(atom));
    }

    public static int getFreeRgroupAttachmentCount(MolAtom atom, Sgroup sgroup) {
        int count;
        int n = count = atom.getAttach() == 3 ? 2 : 1;
        if (sgroup == null) {
            return count;
        }
        for (int i = atom.getBondCount() - 1; i >= 0 && (sgroup.hasAtom(atom.getLigand(i)) || --count != 0); --i) {
        }
        return count;
    }

    public static SuperatomSgroup getContainingSuperatomSgroup(MolAtom atom) {
        Sgroup sgroup;
        if (!(atom.getParent() instanceof Molecule)) {
            return null;
        }
        Molecule mol = (Molecule)atom.getParent();
        for (sgroup = mol.findSgroupOf(atom); sgroup != null && !(sgroup instanceof SuperatomSgroup); sgroup = sgroup.getParentSgroup()) {
        }
        return sgroup instanceof SuperatomSgroup ? (SuperatomSgroup)sgroup : null;
    }

    private static void setLigandOrdersByAtomIndex(final Molecule mol, MolAtom ratom) {
        int bondCount = ratom.getBondCount();
        if (bondCount == 0) {
            return;
        }
        if (bondCount == 1) {
            ratom.setLigandOrder(1, ratom.getLigand(0));
            return;
        }
        if (bondCount == 2) {
            MolAtom ligand1 = ratom.getLigand(0);
            MolAtom ligand2 = ratom.getLigand(1);
            if (mol.indexOf(ligand1) < mol.indexOf(ligand2)) {
                ratom.setLigandOrder(1, ligand1);
                ratom.setLigandOrder(2, ligand2);
            } else {
                ratom.setLigandOrder(2, ligand1);
                ratom.setLigandOrder(1, ligand2);
            }
            return;
        }
        MolAtom[] ligands = ratom.getLigands();
        Arrays.sort(ligands, new Comparator<MolAtom>(){

            @Override
            public int compare(MolAtom o1, MolAtom o2) {
                return mol.indexOf(o1) - mol.indexOf(o2);
            }
        });
        for (int i = 0; i < ligands.length; ++i) {
            ratom.setLigandOrder(i + 1, ligands[i]);
        }
    }

    public static MolAtom[] getLigandsInOrder(MolAtom atom) {
        MolAtom[] ligands = new MolAtom[atom.getBondCount()];
        for (int i = 0; i < ligands.length; ++i) {
            MolAtom ligand;
            ligands[atom.getLigandOrder((MolAtom)ligand) - 1] = ligand = atom.getLigand(i);
        }
        return ligands;
    }

    public static MolAtom getLigandByOrder(MolAtom atom, int order) {
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = atom.getLigand(i);
            if (atom.getLigandOrder(ligand) != order) continue;
            return ligand;
        }
        return null;
    }

    public static boolean setLigandOrders(MolAtom atom, MolAtom[] ligands) {
        for (int i = 0; i < ligands.length; ++i) {
            if (atom.setLigandOrder(i + 1, ligands[i])) continue;
            return false;
        }
        return true;
    }

    public static MolAtom[] getAttachments(Molecule m) {
        ArrayList<MolAtom> attachmentList = new ArrayList<MolAtom>();
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = m.getAtom(i);
            if (atom.getAtno() != 138) continue;
            attachmentList.add(atom);
        }
        MolAtom[] attachments = new MolAtom[attachmentList.size()];
        Iterator i$ = attachmentList.iterator();
        while (i$.hasNext()) {
            MolAtom attachment;
            attachments[attachment.getRgroupAttachmentPointOrder() - 1] = attachment = (MolAtom)i$.next();
        }
        return attachments;
    }

    private static boolean hasAttachment(RgMolecule rgmol, int rgindex) {
        for (int i = rgmol.getRgroupMemberCount(rgindex) - 1; i >= 0; --i) {
            if (!MolImportUtil.hasAttachment(rgmol.getRgroupMember(rgindex, i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttachment(MoleculeGraph m) {
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            if (m.getAtom(i).getAtno() != 138) continue;
            return true;
        }
        return false;
    }

    public static int countAttachments(MoleculeGraph m) {
        int count = 0;
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            if (m.getAtom(i).getAtno() != 138) continue;
            ++count;
        }
        return count;
    }

    public static MolAtom addCleanedRgroupAttachmentPoint(MolAtom atom, int order, int bondtype) {
        MolAtom[] ligands;
        MolAtom attachment = atom.addRgroupAttachmentPoint(order, bondtype);
        SuperatomSgroup sgroup = MolImportUtil.getContainingSuperatomSgroup(atom);
        ArrayList<SuperatomSgroup> sglist = null;
        if (sgroup != null && sgroup.getXState() == 3) {
            sgroup.setGUIStateRecursively(true);
            atom = sgroup.getSuperAtom();
            sglist = new ArrayList<SuperatomSgroup>();
            sglist.add(sgroup);
        }
        for (MolAtom ligand : ligands = atom.getLigands()) {
            SuperatomSgroup sg = MolImportUtil.getContainingSuperatomSgroup(ligand);
            if (sg == null || sg.getXState() != 3) continue;
            sg.setGUIStateRecursively(true);
            if (sglist == null) {
                sglist = new ArrayList(ligands.length);
            }
            sglist.add(sg);
        }
        CleanUtil.setBestLigandPosition(atom, attachment);
        if (sglist != null) {
            for (SuperatomSgroup sg : sglist) {
                sg.setGUIStateRecursively(false);
            }
        }
        return attachment;
    }

    public static MolAtom[] getAtomsWithAttachments(Molecule m) {
        MolAtom[] attachments = MolImportUtil.getAttachments(m);
        MolAtom[] atoms = new MolAtom[attachments.length];
        for (int i = 0; i < atoms.length; ++i) {
            if (attachments[i].getBondCount() != 1) {
                throw new IllegalArgumentException("Bad attachment data for attachment atom of index: " + i);
            }
            atoms[i] = attachments[i].getLigand(0);
        }
        return atoms;
    }

    public static int countAttachments(MolAtom atom) {
        int attachmentCount = 0;
        int n = atom.getBondCount();
        for (int i = 0; i < n; ++i) {
            if (atom.getLigand(i).getAtno() != 138) continue;
            ++attachmentCount;
        }
        return attachmentCount;
    }

    public static int countSingleAtomAttachments(MolAtom atom) {
        int attachmentCount = 0;
        if (attachmentCount == 0 && atom.getBondCount() == 0 && atom.getParent() != null && atom.getParent().getParent() instanceof RgMolecule) {
            long rgMemInd;
            RgMolecule rgm = (RgMolecule)atom.getParent().getParent();
            int atomCount = rgm.getGraphUnion().getAtomCount();
            block0: while (attachmentCount == 0 && (rgMemInd = rgm.getRgroupMemberID(atom)) >= 0L) {
                int rgInd = rgm.getRgroupIndex(rgMemInd);
                int rgID = rgm.getRgroupId(rgInd);
                for (int i = 0; i < atomCount; ++i) {
                    MolAtom at = rgm.getAtom(i);
                    if (at.getAtno() == 134 && at.getRgroup() == rgID) {
                        atom = at;
                        attachmentCount += MolImportUtil.countBondsAndAttachments(atom);
                        continue block0;
                    }
                    if (i == atomCount - 1) break block0;
                }
            }
        }
        return attachmentCount;
    }

    public static int countBondsAndAttachments(MolAtom atom) {
        return atom.getBondCount() + MolImportUtil.countSingleAtomAttachments(atom);
    }

    public static void clearAttachments(MolAtom atom) {
        MoleculeGraph parent = atom.getParent();
        if (!(parent instanceof Molecule)) {
            return;
        }
        Molecule mol = (Molecule)parent;
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            if (atom.getLigand(i).getAtno() != 138) continue;
            mol.removeAtom(atom.getLigand(i));
        }
    }

    public static void clearAttachments(Molecule mol) {
        for (int i = mol.getGraphUnion().getAtomCount() - 1; i >= 0; --i) {
            MolImportUtil.clearAttachments(mol.getAtom(i));
        }
    }

    public static int[] getAttachmentOrders(MolAtom atom) {
        IntVector attachments = new IntVector();
        int n = atom.getBondCount();
        for (int i = 0; i < n; ++i) {
            if (atom.getLigand(i).getAtno() != 138) continue;
            attachments.add(atom.getLigand(i).getRgroupAttachmentPointOrder());
        }
        int[] ret = attachments.toArray();
        Arrays.sort(ret);
        return ret;
    }

    public static MolAtom findParentRAtom(RgMolecule rgmol, MolAtom rgroupAtom) {
        int rid = rgmol.rgroupIdOf(rgroupAtom);
        if (rid == -1) {
            return null;
        }
        return MolImportUtil.findRAtom(rgmol, rid);
    }

    public static MolAtom findRAtom(Molecule mol, int rid) {
        int count = mol.getGraphUnion().getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() != 134 || atom.getRgroup() != rid) continue;
            return atom;
        }
        return null;
    }

    public static void convertAttachments(MoleculeGraph molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            MolAtom atom = molecule.getAtom(i);
            if (atom.getRgroupAttachmentPointOrder() <= 0) continue;
            atom.setAtno(138);
        }
    }

    public static void calcAttachmentPoints(MoleculeGraph mol, double scale) {
        MoleculeGraph graph = mol.getGraphUnion();
        if (!MolImportUtil.hasAttachment(graph)) {
            return;
        }
        boolean contracted = true;
        if (mol.isMolecule() && !(contracted = ((Molecule)mol).isGUIContracted())) {
            ((Molecule)mol).setGUIContracted(true);
        }
        double bondlength = 1.54 / scale;
        for (int i = 0; i < graph.getAtomCount(); ++i) {
            MolAtom atom = graph.getAtom(i);
            if (atom.getAtno() != 138) continue;
            MolAtom neighbour = atom.getLigand(0);
            CleanUtil.setBestLigandPosition(neighbour, atom, bondlength);
        }
        if (!contracted) {
            ((Molecule)mol).setGUIContracted(false);
        }
    }
}

