/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.util.ErrorDisplay;
import chemaxon.marvin.util.HourglassHandler;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class MolLoader
implements Runnable {
    public static final long MOL_ID = -1L;
    public static final long ADD_ID = -2L;
    public static final int TTMPL_MIN = 65536;
    public static final int TTMPL_MAX = 65791;
    public static final int TTMPL_NORMAX = 65790;
    public static final int TTMPL_X = 65791;
    public static final int TMPL_MIN = 65792;
    public static final int USRTMPL_MIN_INDEX = 128;
    public static final int USRTMPL_MAX_INDEX = 255;
    public static final int TMPL_MAX = 66047;
    public static final int ABBREVGROUPS = 66048;
    private static int numberOfInstances = 0;
    private Thread myThread = null;
    private boolean secondRun = false;
    private URL baseURL = null;
    private InputStream inputStream = null;
    private File molfileFile = null;
    private URL molfileURL = null;
    private String molfileContents = null;
    private String molfilePath = null;
    private String molfileFormat = null;
    private Molecule[] loadedMolecules = null;
    private String loadedAbbrevGroups = null;
    private Vector scriptCode;
    private Handler theHandler;
    private final ErrorDisplay errorDisplay;
    private HourglassHandler hourglassHandler;
    private final long myIdentifier;
    private String importOptions;
    private volatile boolean iamDead = false;
    private int debugLevel = 0;

    public MolLoader(InputStream in, String fmtopts, long id, Handler handler, ErrorDisplay errdisp, HourglassHandler hourglass, boolean script, int debug) {
        this.myIdentifier = id;
        this.theHandler = handler;
        this.errorDisplay = errdisp;
        this.hourglassHandler = hourglass;
        this.debugLevel = debug;
        String[] r = MFileFormatUtil.splitFormatAndOptions(fmtopts);
        this.molfileFormat = r[0];
        this.importOptions = fmtopts;
        this.scriptCode = script ? new Vector() : null;
        this.inputStream = in;
        ++numberOfInstances;
    }

    public MolLoader(URL base, String s, long id, Handler handler, ErrorDisplay errdisp, HourglassHandler hourglass, String fmtopts, boolean script, int debug) throws MalformedURLException {
        this.myIdentifier = id;
        this.theHandler = handler;
        this.errorDisplay = errdisp;
        this.hourglassHandler = hourglass;
        this.debugLevel = debug;
        this.init(base, s, fmtopts, script);
        ++numberOfInstances;
    }

    public synchronized void startThread() {
        if (this.myThread == null) {
            Thread t;
            this.myThread = t = new Thread((Runnable)this, "MRV-MolLoader(" + this.myIdentifier + ")");
            t.start();
        }
    }

    public boolean isAlive() {
        Thread t = this.myThread;
        return t != null && t.isAlive();
    }

    private void init(URL base, String s, String fmtopts, boolean script) throws MalformedURLException {
        this.importOptions = fmtopts;
        this.baseURL = base;
        Vector vector = this.scriptCode = script ? new Vector() : null;
        if (s == null || s.equals("")) {
            this.iamDead = true;
            if (!script) {
                this.loadedMolecules = new Molecule[1];
                this.loadedMolecules[0] = new RgMolecule();
            }
            this.theHandler.molLoaderFinished(this);
            return;
        }
        if (base == null) {
            try {
                File f = new File(s);
                if (f.exists()) {
                    this.molfileFile = f;
                    this.molfilePath = s;
                    return;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!script) {
            if (MFileFormatUtil.isURLOrFileName(s)) {
                this.molfileURL = base == null ? new URL(s) : new URL(base, s);
                this.molfilePath = s;
                return;
            }
            boolean nocr = s.indexOf(13) == -1 && s.indexOf(10) == -1;
            int mend = s.indexOf("M  END");
            if (mend > 2 && (s.charAt(mend - 1) == '\\' || s.charAt(mend - 2) == '\\' || s.charAt(mend - 3) == '\\')) {
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c != '\\') {
                        sbuf.append(c);
                        continue;
                    }
                    if (!nocr) continue;
                    sbuf.append('\n');
                }
                s = sbuf.toString();
            }
        }
        this.molfileContents = s;
    }

    public boolean isSecondRun() {
        return this.secondRun;
    }

    public void initSecondRun(Handler handler, HourglassHandler hourglass) {
        this.secondRun = true;
        this.theHandler = handler;
        this.hourglassHandler = hourglass;
    }

    public boolean contentsSpecified() {
        return this.molfileContents != null;
    }

    public static int getNumInstances() {
        return numberOfInstances;
    }

    public static MRecordImporter createImporter(MolInputStream mis, String opts) throws IOException, SecurityException {
        return MolLoader.createImporter(mis, opts, 0, false);
    }

    public static MRecordImporter createImporter(MolInputStream mis, String opts, int debug) throws IOException, SecurityException {
        return MolLoader.createImporter(mis, opts, debug, false);
    }

    private static MRecordImporter createImporter(MolInputStream mis, String opts, int debug, boolean tmpl) throws IOException, SecurityException {
        String fmt = mis.getFormat();
        try {
            int i = fmt.indexOf(58);
            if (i >= 0) {
                fmt = fmt.substring(0, i);
            }
            if (tmpl && (fmt.equals("csmol") || fmt.equals("sdf") || fmt.equals("cssdf") || fmt.equals("rgf") || fmt.equals("csrgf") || fmt.equals("rxn") || fmt.equals("csrxn") || fmt.equals("rdf") || fmt.equals("csrdf"))) {
                opts = opts == null ? "Xsg" : "Xsg,".concat(opts);
            }
            return new MRecordImporter(mis, opts);
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (IncompatibleClassChangeError e) {
            MolLoader.logError(debug, e);
            throw e;
        }
        catch (IOException e) {
            MolLoader.logError(debug, e);
            throw e;
        }
        catch (Throwable t) {
            MolLoader.logError(debug, t);
            throw new IOException("Cannot import file in format " + fmt, t);
        }
    }

    private static void logError(int debug, Throwable ex) {
        if (debug > 1) {
            System.err.println("Could not create importer module: " + ex);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Handler handler;
        block48: {
            InputStream in;
            block46: {
                handler = this.theHandler;
                this.theHandler = null;
                this.hourglassHandler = null;
                if (this.secondRun) {
                    handler.molLoaderFinished(this);
                    return;
                }
                if (this.iamDead) {
                    return;
                }
                if (this.scriptCode == null && this.molfilePath != null) {
                    if (this.getId() == 66048L) {
                        this.loadedAbbrevGroups = null;
                    } else {
                        this.loadedMolecules = handler.getFromMolCache(this.molfilePath);
                        if (this.loadedMolecules != null) {
                            handler.molLoaderFinished(this);
                            return;
                        }
                    }
                }
                if (this.inputStream == null) {
                    if (this.molfileFile != null) {
                        this.inputStream = new FileInputStream(this.molfileFile);
                    } else if (this.molfileURL != null) {
                        try {
                            URLConnection conn = this.molfileURL.openConnection();
                            conn.setUseCaches(false);
                            this.inputStream = conn.getInputStream();
                        }
                        catch (SecurityException sex) {
                            this.errorDisplay.firewallError(sex, null);
                        }
                    } else {
                        if (this.molfileContents == null) throw new IOException("argument is not recognized as a URL or a string of molfile contents");
                        this.inputStream = new StringBufferInputStream(this.molfileContents);
                    }
                }
                if (!this.iamDead) break block46;
                in = this.inputStream;
                if (in == null) return;
                this.inputStream = null;
                try {
                    in.close();
                    return;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return;
            }
            if (this.inputStream != null) {
                if (this.scriptCode == null) {
                    if (this.getId() == 66048L) {
                        this.loadAbbrevGroups();
                    } else {
                        this.loadMol();
                    }
                } else {
                    this.loadScript();
                }
            }
            if ((in = this.inputStream) == null) break block48;
            this.inputStream = null;
            try {
                in.close();
            }
            catch (Exception ex) {}
            break block48;
            catch (Throwable ex) {
                try {
                    if (this.debugLevel > 1) {
                        System.err.println("Could not run molecule loader: " + ex);
                        ex.printStackTrace();
                    }
                    if (this.iamDead) {
                        return;
                    }
                    if (ex instanceof IncompatibleClassChangeError) {
                        this.errorDisplay.error(ex);
                        return;
                    }
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append(this.scriptCode == null ? "Molfile" : "Script");
                    if (ex instanceof FileNotFoundException) {
                        sbuf.append(" not found.\n");
                    } else {
                        sbuf.append(" cannot be loaded because an error occured:\n");
                        sbuf.append(ex.toString());
                        sbuf.append('\n');
                    }
                    sbuf.append("\n#");
                    sbuf.append(Long.toHexString(this.myIdentifier));
                    if (this.molfileURL != null) {
                        sbuf.append(" = ");
                        sbuf.append(this.molfileURL.toString());
                    }
                    this.errorDisplay.error(sbuf.toString(), ex);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    InputStream in2 = this.inputStream;
                    if (in2 != null) {
                        this.inputStream = null;
                        try {
                            in2.close();
                        }
                        catch (Exception ex2) {}
                    }
                }
            }
        }
        if (this.iamDead) {
            return;
        }
        handler.molLoaderFinished(this);
    }

    public static Molecule readMultiSet(MRecordImporter mi, Molecule m) throws MRecordParseException, MolFormatException, IOException {
        Molecule tmp = (Molecule)m.newInstance();
        if (mi.readMol(m) != m) {
            return null;
        }
        int setSeq = 1;
        while (mi.readMol(tmp) != null) {
            tmp.setAtomSetSeqs(setSeq++);
            m.fuse(tmp);
            m.setEndPosition(tmp.getEndPosition());
            tmp = (Molecule)m.newInstance();
        }
        return m;
    }

    public void die() {
        this.iamDead = true;
        this.baseURL = null;
        this.molfileFile = null;
        this.molfileURL = null;
        this.molfileContents = null;
        this.molfilePath = null;
        this.importOptions = null;
        this.theHandler = null;
        this.hourglassHandler = null;
        this.myThread = null;
    }

    public void clear() {
        this.die();
        this.loadedMolecules = null;
        this.loadedAbbrevGroups = null;
        this.scriptCode = null;
    }

    public long getId() {
        return this.myIdentifier;
    }

    public Molecule[] getMols() {
        return this.loadedMolecules;
    }

    public String getAbbrevGroups() {
        return this.loadedAbbrevGroups;
    }

    public Vector getScript() {
        return this.scriptCode;
    }

    public File getFile() {
        return this.molfileFile;
    }

    public String getPath() {
        return this.molfilePath;
    }

    public boolean isAnimated() {
        String f;
        Molecule[] m = this.loadedMolecules;
        if (m.length > 1 && m[0] != null && (f = m[0].getInputFormat()) != null) {
            return f.equals("xyz");
        }
        return false;
    }

    private void loadMol() throws Exception {
        String[] encopts = MFileFormatUtil.getEncodingFromOptions(this.importOptions);
        String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(encopts[1]);
        int result = MFileFormatUtil.preprocessFormatAndOptions(fmtopts);
        if (fmtopts[0] == null) {
            if (this.molfileFormat != null) {
                fmtopts[0] = this.molfileFormat;
            } else if (this.molfilePath != null) {
                fmtopts[0] = MFileFormatUtil.getUnguessableFormat(this.molfilePath);
            }
        }
        MolInputStream mis = new MolInputStream(this.inputStream, fmtopts[0], encopts[0], this.molfilePath);
        boolean istmpl = this.getId() >= 65792L && this.getId() <= 66047L;
        MRecordImporter mi = MolLoader.createImporter(mis, fmtopts[1], this.debugLevel, istmpl);
        Vector<Molecule> v = (result & 1) != 0 ? null : new Vector<Molecule>();
        RgMolecule m0 = new RgMolecule();
        if (this.iamDead) {
            return;
        }
        int setSeq = 0;
        MDocument doc = null;
        while ((doc = mi.readDoc()) != null) {
            Molecule m = (Molecule)doc.getMainMoleculeGraph();
            if (v != null) {
                v.addElement(m);
                m = new RgMolecule();
                doc = new MDocument(m);
            } else {
                m.setAtomSetSeqs(setSeq);
                m0.fuse(m);
                m0.setEndPosition(m.getEndPosition());
            }
            Thread.yield();
            if (this.iamDead) {
                return;
            }
            ++setSeq;
        }
        if (v != null) {
            this.loadedMolecules = new Molecule[v.size()];
            v.copyInto(this.loadedMolecules);
        } else {
            new MDocument(m0);
            this.loadedMolecules = new Molecule[1];
            this.loadedMolecules[0] = m0;
        }
    }

    private void loadAbbrevGroups() throws Exception {
        String s;
        StringBuffer sb = new StringBuffer();
        InputStreamReader r = new InputStreamReader(this.inputStream);
        LineNumberReader lr = new LineNumberReader(r);
        do {
            if ((s = lr.readLine()) == null) continue;
            sb.append(s);
            sb.append('\n');
        } while (s != null);
        this.loadedAbbrevGroups = sb.toString();
    }

    private void loadScript() throws Exception {
        MarvinModule scripter = null;
        try {
            scripter = (MarvinModule)MarvinModule.load("view.RasMolScripter", this.hourglassHandler);
        }
        catch (SecurityException sex) {
            if (this.iamDead) {
                return;
            }
            this.errorDisplay.firewallError(sex, null);
            return;
        }
        scripter.modfunc(this.baseURL);
        scripter.modfunc(this.scriptCode);
        Object o = scripter.modfunc(this.inputStream);
        if (o != null && o instanceof Exception) {
            throw (Exception)o;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        --numberOfInstances;
    }

    public static interface Handler {
        public boolean molLoaderFinished(MolLoader var1);

        public Molecule[] getFromMolCache(String var1);
    }
}

