/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.core.util.GeomUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;

public class MoleculeUtil {
    public static void arrangeCrossingBonds(MolBond bond, Molecule mol, boolean front) {
        MoleculeGraph umol = mol.getGraphUnion();
        int index = umol.indexOf(bond);
        MolBond[] edges = mol.getBondArray();
        MolBond tmp = edges[index];
        if (front) {
            System.arraycopy(edges, index + 1, edges, index, edges.length - index - 1);
            edges[edges.length - 1] = tmp;
        } else {
            System.arraycopy(edges, 0, edges, 1, index - 1);
            edges[0] = tmp;
        }
        mol.sortBondsAccordingTo(edges);
    }

    public static MolBond[] getCrossingBonds(MolBond[] b, DPoint3 e1, DPoint3 e2) {
        return GeomUtil.getCrossingBonds(b, e1, e2, true);
    }
}

