/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

public class OptionDescriptor {
    public static final int BOOL = 0;
    public static final int NONNEGATIVE_REAL = 1;
    private String theName;
    private String theInvName;
    private int theType;
    private String theDescription;
    private String[] optionsToDisable;
    private String[] optionsToEnable;
    private String[] optionsToDeselect;

    public OptionDescriptor(String name, String invname, int type, String desc, String[] disable, String[] enable, String[] deselect) {
        String[] opts;
        int n;
        this.theName = name;
        this.theInvName = invname;
        this.theType = type;
        this.theDescription = desc;
        if (disable != null) {
            n = disable.length;
            opts = new String[n];
            System.arraycopy(disable, 0, opts, 0, n);
            this.optionsToDisable = opts;
        } else {
            this.optionsToDisable = new String[0];
        }
        if (enable != null) {
            n = enable.length;
            opts = new String[n];
            System.arraycopy(enable, 0, opts, 0, n);
            this.optionsToEnable = opts;
        } else {
            this.optionsToEnable = new String[0];
        }
        if (deselect != null) {
            n = deselect.length;
            opts = new String[n];
            System.arraycopy(deselect, 0, opts, 0, n);
            this.optionsToDeselect = opts;
        } else {
            this.optionsToDeselect = new String[0];
        }
    }

    public String getName() {
        return this.theName;
    }

    public String getInverseName() {
        return this.theInvName;
    }

    public boolean isDefaultSelected() {
        return this.theInvName != null;
    }

    public int getType() {
        return this.theType;
    }

    public String getDescription() {
        return this.theDescription;
    }

    public String[] getOptionsToDisable() {
        int n = this.optionsToDisable.length;
        String[] opts = new String[n];
        System.arraycopy(this.optionsToDisable, 0, opts, 0, n);
        return opts;
    }

    public String[] getOptionsToEnable() {
        int n = this.optionsToEnable.length;
        String[] opts = new String[n];
        System.arraycopy(this.optionsToEnable, 0, opts, 0, n);
        return opts;
    }

    public String[] getOptionsToDeselect() {
        int n = this.optionsToDeselect.length;
        String[] opts = new String[n];
        System.arraycopy(this.optionsToDeselect, 0, opts, 0, n);
        return opts;
    }

    public static int parseType(String s) {
        if (s.equalsIgnoreCase("BOOL")) {
            return 0;
        }
        if (s.equalsIgnoreCase("NONNEGATIVE_REAL")) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown option type \"" + s + "\"");
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(i >= 0 ? s.substring(i + 1) : s);
        sb.append('[');
        sb.append(this.getName());
        if (this.theInvName != null) {
            sb.append("/");
            sb.append(this.theInvName);
        }
        sb.append(']');
        return sb.toString();
    }
}

