/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;

public class PackedIntArray {
    private int nbits;
    private Map<Integer, Integer> packMap;
    private Map<Integer, Integer> unpackMap;
    private BitSet bitlist;
    private int size;

    public PackedIntArray() {
        Integer zero = new Integer(0);
        this.packMap = new TreeMap<Integer, Integer>();
        this.packMap.put(zero, zero);
        this.unpackMap = new TreeMap<Integer, Integer>();
        this.unpackMap.put(zero, zero);
        this.nbits = 0;
        this.bitlist = null;
    }

    public int get(int k) {
        if (k >= this.size) {
            return 0;
        }
        int pali = 0;
        int bi = k * this.nbits;
        for (int j = 0; j < this.nbits; ++j) {
            if (!this.bitlist.get(bi + j)) continue;
            pali |= 1 << j;
        }
        return this.unpackMap.get(new Integer(pali));
    }

    public boolean set(int k, int value) {
        int pali;
        Integer valueI = new Integer(value);
        Integer paliI = this.packMap.get(valueI);
        int n = pali = paliI != null ? paliI : -1;
        if (pali == 0) {
            boolean changed = false;
            if (k < this.size) {
                int bi = k * this.nbits;
                for (int j = 0; j < this.nbits; ++j) {
                    boolean prev = this.bitlist.get(bi + j);
                    if (!prev) continue;
                    this.bitlist.set(bi + j, false);
                    changed = true;
                }
            }
            return changed;
        }
        if (pali < 0) {
            pali = this.packMap.size();
            this.packMap.put(valueI, pali);
            this.unpackMap.put(pali, valueI);
            if (this.nbits == 0) {
                this.nbits = 1;
                this.size = k + 1;
                this.bitlist = new BitSet(this.size);
            } else if (pali >= 1 << this.nbits) {
                for (int i = this.size - 1; i >= 0; --i) {
                    int bi = i * this.nbits;
                    int bi2 = i * (this.nbits + 1);
                    this.bitlist.set(bi2 + this.nbits, false);
                    for (int j = this.nbits - 1; j >= 0; --j) {
                        boolean b = this.bitlist.get(bi + j);
                        this.bitlist.set(bi2 + j, b);
                    }
                }
                ++this.nbits;
            }
        }
        if (k >= this.size) {
            this.size = k + 1;
        }
        int bi = k * this.nbits;
        boolean changed = false;
        for (int j = 0; j < this.nbits; ++j) {
            boolean bit;
            boolean prev = this.bitlist.get(bi + j);
            boolean bl = bit = (pali & 1 << j) != 0;
            if (prev == bit) continue;
            this.bitlist.set(bi + j, bit);
            changed = true;
        }
        return changed;
    }
}

