/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util;

import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class SwingUtil
implements Serializable {
    private static final long serialVersionUID = -1600625160321014724L;

    public static void initInApplet() {
    }

    public static KeyStroke getCommandKeyStroke(int key) {
        int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(key, mod);
    }

    public static JMenuItem createMenuItem(ResourceBundle rc, String key, Class what, boolean mnemo) {
        try {
            JMenuItem mi = (JMenuItem)what.newInstance();
            SwingUtil.initButton(mi, rc, key, mnemo);
            return mi;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static JMenuItem createMenuItem(ResourceBundle rc, String key, boolean mnemo) {
        return SwingUtil.createMenuItem(rc, key, JMenuItem.class, mnemo);
    }

    public static JMenuItem createMenuItem(ResourceBundle rc, String key) {
        return SwingUtil.createMenuItem(rc, key, JMenuItem.class, true);
    }

    public static JMenu createMenu(ResourceBundle rc, String key) {
        return (JMenu)SwingUtil.createMenuItem(rc, key, JMenu.class, true);
    }

    public static JMenu createMenu(ResourceBundle rc, String key, boolean mnemo) {
        return (JMenu)SwingUtil.createMenuItem(rc, key, JMenu.class, mnemo);
    }

    public static void initButton(AbstractButton b, ResourceBundle rc, String key) {
        SwingUtil.initButton(b, rc, key, true);
    }

    public static void initButton(AbstractButton b, ResourceBundle rc, String key, boolean mnemo) {
        String label = rc.getString(key);
        if (label.startsWith("'") && label.length() > 3 && label.charAt(2) == '\'') {
            b.setText(label.substring(3));
            if (mnemo) {
                b.setMnemonic(label.charAt(1));
            }
        } else {
            b.setText(label);
        }
    }

    public static void initAction(Action action, ResourceBundle rc, String key, KeyStroke accel) {
        String label = rc.getString(key);
        if (label.startsWith("'") && label.length() > 3 && label.charAt(2) == '\'') {
            action.putValue("Name", label.substring(3));
            action.putValue("MnemonicKey", new Integer(Character.toUpperCase(label.charAt(1))));
        } else {
            action.putValue("Name", label);
        }
        if (accel != null) {
            action.putValue("AcceleratorKey", accel);
        }
    }

    public static void initCtrlShortcutForMac(JMenuItem mi) {
    }

    public static void decorateSubPanel(JPanel panel, String title) {
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
    }

    public static JPanel createSubPanel(String title) {
        JPanel panel = new JPanel();
        SwingUtil.decorateSubPanel(panel, title);
        return panel;
    }

    public static GridBagConstraints createTopLeftConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        return gbc;
    }

    public static JEditorPane createMessagePane(String text) {
        JEditorPane pane = new JEditorPane("text/html", text);
        SwingUtil.setDefaultFont(pane);
        pane.setOpaque(false);
        pane.setEditable(false);
        SwingUtil.addHyperlinkListener(pane);
        return pane;
    }

    public static void setDefaultFont(JEditorPane editorPane) {
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
    }

    public static void addHyperlinkListener(JEditorPane editorPane) {
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public static <T> FutureTask<T> invokeLater(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        SwingUtilities.invokeLater(task);
        return task;
    }

    public static <T> T invokeAndWait(Callable<T> callable) throws InterruptedException, InvocationTargetException {
        try {
            return SwingUtil.invokeLater(callable).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof InvocationTargetException) {
                throw (InvocationTargetException)t;
            }
            throw new InvocationTargetException(t);
        }
    }
}

