/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.jep.UserParam;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.DefaultCompletable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;

public class CompletableDisplayHelper {
    static final String ARGUMENTS_TITLE = "Arguments:";
    static final String ARGUMENTS_OPTIONAL = "(optional)";
    static final String ARGUMENTS_MULTIPLE = "(multiple)";
    static final String FUNCTION_RETURNS = "Returns ";
    static final String EXAMPLE = "Example:";

    public static JEditorPane createDescriptionField() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/html");
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body{ font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        String bulletRule = "li{ list-style-type: circle; list-style-position: inside; }";
        ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule(bulletRule);
        editorPane.setFocusable(false);
        editorPane.setEditable(false);
        Color bgr = (Color)UIManager.get("ToolTip.background");
        if (bgr == null) {
            bgr = new Color(255, 246, 158);
        }
        editorPane.setBackground(bgr);
        editorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return editorPane;
    }

    public static String getFullDescription(Completable completable, boolean expertMode) {
        String desc = completable.getDescription();
        StringBuffer message = new StringBuffer(desc == null || desc.length() == 0 ? "No description<br>" : desc + "<br>");
        if (completable instanceof DefaultCompletable) {
            UserParam[] params = ((DefaultCompletable)completable).getParameters();
            message.append(((DefaultCompletable)completable).getImageTag());
            message.append("<br>");
            if (expertMode && params != null && params.length > 0) {
                message.append("<u>");
                message.append(ARGUMENTS_TITLE);
                message.append("</u><ul>");
                for (int i = 0; i < params.length; ++i) {
                    message.append("<b>");
                    message.append(params[i].getType());
                    message.append("</b>&nbsp;");
                    message.append(params[i].getName());
                    message.append("&nbsp;");
                    if (!params[i].isMandatory()) {
                        message.append("<i>");
                        message.append(ARGUMENTS_OPTIONAL);
                        message.append("</i>");
                    }
                    if (params[i].isMultiple()) {
                        message.append("<i>");
                        message.append(ARGUMENTS_MULTIPLE);
                        message.append("</i>");
                    }
                    message.append("<br>");
                }
                message.append("</ul><br>");
            } else if (((DefaultCompletable)completable).getParameterDescription() != null && ((DefaultCompletable)completable).getParameterDescription().length() > 0) {
                message.append("<b>");
                message.append(ARGUMENTS_TITLE);
                message.append("</b><br>");
                message.append(((DefaultCompletable)completable).getParameterDescription());
                message.append("<br>");
            }
            if (expertMode && completable.getType() != Completable.CompletableType.CONSTANT) {
                message.append(FUNCTION_RETURNS);
                message.append("<b>");
                message.append(((DefaultCompletable)completable).getReturnType());
                message.append("</b><br>");
            }
            message.append("<br>");
            String examples = completable.getExample();
            if (examples != null && examples.trim().length() > 0) {
                message.append("<b>");
                message.append(EXAMPLE);
                message.append("</b><br>");
                message.append(examples);
            }
        }
        return message.toString();
    }

    public static final String getFullDescription(Completable completable) {
        return CompletableDisplayHelper.getFullDescription(completable, false);
    }

    public static JTextField createTipOnEmptyTextField(final String text) {
        JTextField textField = new JTextField(){
            private static final long serialVersionUID = -7375795683496853261L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.getText().length() == 0) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setColor(Color.GRAY);
                    Font font = this.getFont();
                    float height = this.getFontMetrics(font).getLineMetrics(text, g2).getHeight();
                    float top = ((float)this.getHeight() - height) / 2.0f;
                    float left = (this.getWidth() - this.getFontMetrics(font).stringWidth(text)) / 2;
                    g2.drawString(text, left, top + height - 4.0f);
                    g2.dispose();
                }
            }
        };
        return textField;
    }
}

