/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.jep.UserParam;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.DefaultCompletable;
import chemaxon.marvin.util.codeassist.UserDefinedCompletable;
import java.text.ParseException;
import java.util.LinkedList;

public class CompletableFactory {
    private CompletableFactory() {
    }

    static Completable parseString(String string, Completable.CompletableType type) throws ParseException {
        LinkedList<UserParam> arguments;
        String name;
        DefaultCompletable item = null;
        int lParenIndex = string.indexOf(40);
        int rParenIndex = string.indexOf(41);
        if (lParenIndex > -1 && rParenIndex > -1) {
            name = string.substring(0, lParenIndex);
            arguments = new LinkedList<UserParam>();
            if (lParenIndex + 1 < rParenIndex) {
                String[] args = string.substring(lParenIndex + 1, rParenIndex).split(",");
                for (int i = 0; i < args.length; ++i) {
                    int sepIndex;
                    boolean mandatory = true;
                    args[i] = args[i].trim();
                    if (args[i].equalsIgnoreCase("[...")) {
                        UserParam pOld = (UserParam)arguments.get(i - 1);
                        UserParam pNew = new UserParam(pOld.getName(), pOld.getType(), pOld.isMandatory(), true, pOld.getDefaultValue());
                        arguments.set(i - 1, pNew);
                        continue;
                    }
                    if (args[i].charAt(0) == '[') {
                        mandatory = false;
                    }
                    if (args[i].endsWith("]") && mandatory) continue;
                    if (!mandatory) {
                        args[i] = args[i].substring(1, args[i].endsWith("]") ? args[i].length() - 1 : args[i].length());
                    }
                    if ((sepIndex = args[i].indexOf(32)) > -1) {
                        String pType = args[i].substring(0, sepIndex);
                        String pName = args[i].substring(sepIndex + 1);
                        arguments.add(new UserParam(pName, pType, mandatory));
                        continue;
                    }
                    throw new ParseException("Not a valid CompletionItem, Invalid Argument: '" + args[i] + "'", -1);
                }
            }
        } else {
            throw new ParseException("Not a valid CompletionItem: missing '(' or ')'", -1);
        }
        item = new DefaultCompletable(name, type, arguments.toArray(new UserParam[0]));
        return item;
    }

    public static Completable parseAsFunction(String string) {
        Completable item = null;
        try {
            item = CompletableFactory.parseString(string, Completable.CompletableType.FUNCTION);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return item;
    }

    public static Completable parseAsPlugIn(String string) {
        Completable item = null;
        try {
            item = CompletableFactory.parseString(string, Completable.CompletableType.PLUG_IN);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return item;
    }

    public static Completable parseAsMacro(String string) {
        String[] data = string.split("\t");
        UserDefinedCompletable item = null;
        if (data.length == 3) {
            for (int i = 0; i < 3; ++i) {
                data[i] = data[i].replaceAll("\\\\t", "\t");
                data[i] = data[i].replaceAll("\\\\n", "\n");
            }
            item = new UserDefinedCompletable(data[0], data[1], data[2]);
        }
        return item;
    }
}

