/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.jep.UserParam;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.UIManager;

public class DefaultCompletable
implements Completable,
Comparable<Completable> {
    protected static final String UNCATEGORIZED = "Uncategorized";
    private static final String IMG_BGR_COLOR;
    private String name;
    private String description;
    private UserParam[] parameters;
    private Completable.CompletableType type;
    private String returnType;
    private String[] categories;
    private String examples;
    private String parameterDesc;
    private String imageData = null;
    private String imagePath = null;

    public DefaultCompletable(String name, Completable.CompletableType type) {
        this(name, type, new UserParam[0]);
    }

    public DefaultCompletable(String name, Completable.CompletableType type, String description) {
        this(name, type, new UserParam[0], "Unknown", description);
    }

    public DefaultCompletable(String name, Completable.CompletableType type, UserParam[] parameters) {
        this(name, type, parameters, "Unknown");
    }

    public DefaultCompletable(String name, Completable.CompletableType type, UserParam[] parameters, String returnType) {
        this(name, type, parameters, returnType, "No Description");
    }

    public DefaultCompletable(String name, Completable.CompletableType type, UserParam[] parameters, String returnType, String description) {
        this(name, type, parameters, returnType, description, "No Examples");
    }

    public DefaultCompletable(String name, Completable.CompletableType type, UserParam[] parameters, String returnType, String description, String examples) {
        this(name, type, parameters, returnType, description, examples, new String[]{UNCATEGORIZED});
    }

    public DefaultCompletable(String name, Completable.CompletableType type, UserParam[] parameters, String returnType, String description, String examples, String[] categories) {
        this.name = name == null ? "Unnamed" : name;
        this.type = type;
        this.parameters = parameters == null ? new UserParam[]{} : parameters;
        this.returnType = returnType == null ? "Unknown" : returnType;
        this.description = description == null ? "No Description" : description;
        this.categories = categories;
        this.examples = examples;
        this.parameterDesc = "No Description";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UserParam[] getParameters() {
        return this.parameters;
    }

    public void setParameters(UserParam[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public Completable.CompletableType getType() {
        return this.type;
    }

    public void setType(Completable.CompletableType type) {
        this.type = type;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String[] getCategories() {
        return this.categories;
    }

    @Override
    public String getExample() {
        return this.examples;
    }

    public String getParameterDescription() {
        return this.parameterDesc;
    }

    public void setParameterDescription(String description) {
        this.parameterDesc = description;
    }

    @Override
    public int compareTo(Completable o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        if (this.parameters.length > 0) {
            for (int i = 0; i < this.parameters.length; ++i) {
                builder.append(i == 0 ? "(" : ", ");
                if (!this.parameters[i].isMandatory()) {
                    builder.append("[");
                }
                builder.append((this.parameters[i].getType().trim().length() == 0 ? "Unknown" : this.parameters[i].getType().trim()) + " ");
                builder.append(this.parameters[i].getName().trim().length() == 0 ? "Unnamed" : this.parameters[i].getName().trim());
                if (this.parameters[i].isMultiple()) {
                    builder.append(", [..., " + (this.parameters[i].getName().trim().length() == 0 ? "Unnamed" : this.parameters[i].getName().trim()) + "]");
                }
                if (this.parameters[i].isMandatory()) continue;
                builder.append("]");
            }
            builder.append(")");
        } else if (this.type != Completable.CompletableType.CONSTANT) {
            builder.append("()");
        }
        return builder.toString();
    }

    public String toSimpleString() {
        StringBuilder builder = new StringBuilder(this.name);
        if (this.parameters.length > 0) {
            builder.append("(");
            int argc = 0;
            for (int i = 0; i < this.parameters.length; ++i) {
                if (!this.parameters[i].isMandatory()) continue;
                if (argc > 0) {
                    builder.append(", ");
                }
                ++argc;
                builder.append(this.parameters[i].getName().trim().length() == 0 ? "Unnamed" : this.parameters[i].getName().trim());
            }
            builder.append(")");
        } else if (this.type != Completable.CompletableType.CONSTANT) {
            builder.append("()");
        }
        return builder.toString();
    }

    public boolean matchCategory(String category) {
        for (int i = 0; i < this.categories.length; ++i) {
            if (!this.categories[i].equalsIgnoreCase(category)) continue;
            return true;
        }
        return false;
    }

    public DefaultCompletable cloneCompletable() {
        return new DefaultCompletable(this.name, this.type, this.parameters, this.returnType, this.description, this.examples, this.categories);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultCompletable) {
            return this.toString().equalsIgnoreCase(obj.toString());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setImageData(String data) {
        this.imageData = data;
    }

    public String getImageData() {
        return this.imageData;
    }

    public String getImageTag() {
        if (!(this.imageData == null || this.imagePath != null && new File(this.imagePath).canRead())) {
            this.generateImage();
        }
        if (this.imagePath != null) {
            try {
                this.imagePath = URLEncoder.encode(this.imagePath, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return "<img alt=\"image\" src=\"file:/" + this.imagePath + "\">";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateImage() {
        FileOutputStream stream = null;
        MolExporter exporter = null;
        try {
            File tempFile = File.createTempFile("codeAssistImage", ".png");
            tempFile.deleteOnExit();
            stream = new FileOutputStream(tempFile);
            exporter = new MolExporter(stream, "png:w300,h200,b24" + IMG_BGR_COLOR);
            Molecule mol = MolImporter.importMol(this.getImageData());
            if (mol != null) {
                exporter.write(mol);
                this.imagePath = tempFile.getCanonicalPath();
            } else {
                this.imagePath = null;
            }
        }
        catch (Exception e) {
            this.imagePath = null;
        }
        finally {
            try {
                if (exporter != null) {
                    exporter.close();
                }
            }
            catch (IOException e) {}
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static {
        Color bgr = (Color)UIManager.get("ToolTip.background");
        if (bgr == null) {
            bgr = new Color(255, 246, 158);
        }
        StringBuilder builder = new StringBuilder("#");
        builder.append(Integer.toHexString(bgr.getRed()));
        builder.append(Integer.toHexString(bgr.getGreen()));
        builder.append(Integer.toHexString(bgr.getBlue()));
        IMG_BGR_COLOR = builder.toString();
    }
}

