/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist;

import chemaxon.jep.CTFunctionData;
import chemaxon.jep.Evaluator;
import chemaxon.jep.UserParam;
import chemaxon.marvin.util.codeassist.CodeAssistDataProvider;
import chemaxon.marvin.util.codeassist.CodeAssistMacrosHelper;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.DefaultCompletable;
import chemaxon.nfunk.jep.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class EvaluatorCodeAssistDataProvider
implements CodeAssistDataProvider {
    private final List<Completable> itemList;
    private final List<String> keywordList = new ArrayList<String>();
    private static final Set<String> categorySet = new HashSet<String>();
    private static final CodeAssistMacrosHelper macrosHelper = new CodeAssistMacrosHelper();

    @Override
    public Iterator<Completable> getItemIterator() {
        final Iterator<Completable> source = this.itemList.iterator();
        return new Iterator<Completable>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public Completable next() {
                return (Completable)source.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<String> getKeywordIterator() {
        final Iterator<String> source = this.keywordList.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public String next() {
                return (String)source.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public EvaluatorCodeAssistDataProvider(CodeAssistDataProvider.Context context) throws ParseException {
        this(context, true);
    }

    public EvaluatorCodeAssistDataProvider(CodeAssistDataProvider.Context context, boolean addServices) throws ParseException {
        this.keywordList.add("and");
        this.keywordList.add("or");
        this.keywordList.add("not");
        this.itemList = new LinkedList<Completable>();
        Evaluator evaluator = new Evaluator();
        Hashtable<String, CTFunctionData> functionDataTable = evaluator.getFunctionData(addServices);
        Set<String> keys = functionDataTable.keySet();
        for (String functName : keys) {
            String extended;
            CTFunctionData data = functionDataTable.get(functName);
            StringBuffer example = new StringBuffer();
            String general = data.getGeneralExample();
            String string = extended = context == CodeAssistDataProvider.Context.MOLECULE ? data.getMoleculeContextExample() : data.getReactionContextExample();
            if (general != null && general.trim().length() > 0) {
                example.append(general);
            }
            if (extended != null && extended.trim().length() > 0) {
                example.append("<br>" + extended);
            }
            UserParam[] functParams = data.getUserParams();
            String[] cats = data.getCategories();
            for (int i = 0; i < cats.length; ++i) {
                if (cats[i] == null || cats[i].length() <= 0) continue;
                categorySet.add(cats[i]);
            }
            DefaultCompletable completable = new DefaultCompletable(functName, data.getFunctionType() == CTFunctionData.PLUGIN_FUNCTION ? Completable.CompletableType.PLUG_IN : Completable.CompletableType.FUNCTION, functParams, data.getReturnType(), data.getDescription(), example.toString(), data.getCategories());
            completable.setParameterDescription(data.getParameters());
            this.itemList.add(completable);
        }
        Set constants = evaluator.getSymbolTable().keySet();
        Hashtable<String, String> displayTable = evaluator.getFunctionalGroupDisplayMolTable();
        for (String constant : constants) {
            DefaultCompletable constantCompletable = new DefaultCompletable(constant, Completable.CompletableType.CONSTANT, (String)evaluator.getSymbolTable().get(constant));
            constantCompletable.setImageData(displayTable.get(constant));
            this.itemList.add(constantCompletable);
        }
        macrosHelper.readMacros();
        Iterator<Completable> it = macrosHelper.getMacros().iterator();
        while (it.hasNext()) {
            this.itemList.add(it.next());
        }
    }

    @Override
    public Iterator<String> getCategoryIterator() {
        return categorySet.iterator();
    }

    @Override
    public void addItem(Completable item) {
        this.itemList.add(item);
    }

    @Override
    public void addKeyword(String keyword) {
        this.keywordList.add(keyword);
    }

    @Override
    public boolean removeItem(Completable item) {
        return this.itemList.remove(item);
    }

    @Override
    public boolean removeKeyword(String keyword) {
        return this.keywordList.remove(keyword);
    }
}

